/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class LongVarcharColumnMapping
extends AbstractColumnMapping {
    public LongVarcharColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    @Override
    public boolean isStringBased() {
        return true;
    }

    private void initialize() {
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return -1;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else {
                ps.setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"String", value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        String value;
        try {
            value = rs.getString(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"String", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getJDBCType());
            } else {
                ps.setString(param, (String)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        String value;
        try {
            String s = rs.getString(param);
            value = rs.wasNull() ? null : s;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

