/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class StringIndexOf2Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        SQLExpression substrExpr = args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 0, "StringExpression/CharacterExpression/ParameterLiteral"}));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(stmt);
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(expr);
        funcArgs.add(substrExpr);
        if (args.size() == 2) {
            SQLExpression fromExpr = args.get(1);
            if (!(fromExpr instanceof NumericExpression)) {
                throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"indexOf", "StringExpression", 1, "NumericExpression"}));
            }
            funcArgs.add(fromExpr.add(one));
        }
        NumericExpression locateExpr = new NumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE), "INSTR", funcArgs);
        return new NumericExpression(locateExpr, Expression.OP_SUB, one).encloseInParentheses();
    }
}

