/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tez;

import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class Converters {
    public static TaskSpec getTaskSpecfromProto(LlapDaemonProtocolProtos.SignableVertexSpec vectorProto, int fragmentNum, int attemptNum, TezTaskAttemptID attemptId) {
        TezTaskAttemptID taskAttemptID = attemptId != null ? attemptId : Converters.createTaskAttemptId(vectorProto.getQueryIdentifier(), vectorProto.getVertexIndex(), fragmentNum, attemptNum);
        ProcessorDescriptor processorDescriptor = null;
        if (vectorProto.hasProcessorDescriptor()) {
            processorDescriptor = Converters.convertProcessorDescriptorFromProto(vectorProto.getProcessorDescriptor());
        }
        ArrayList<InputSpec> inputSpecList = new ArrayList<InputSpec>(vectorProto.getInputSpecsCount());
        if (vectorProto.getInputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.IOSpecProto iOSpecProto : vectorProto.getInputSpecsList()) {
                inputSpecList.add(Converters.getInputSpecFromProto(iOSpecProto));
            }
        }
        ArrayList<OutputSpec> outputSpecList = new ArrayList<OutputSpec>(vectorProto.getOutputSpecsCount());
        if (vectorProto.getOutputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.IOSpecProto iOSpecProto : vectorProto.getOutputSpecsList()) {
                outputSpecList.add(Converters.getOutputSpecFromProto(iOSpecProto));
            }
        }
        ArrayList<GroupInputSpec> arrayList = new ArrayList<GroupInputSpec>(vectorProto.getGroupedInputSpecsCount());
        if (vectorProto.getGroupedInputSpecsCount() > 0) {
            for (LlapDaemonProtocolProtos.GroupInputSpecProto groupInputSpecProto : vectorProto.getGroupedInputSpecsList()) {
                arrayList.add(Converters.getGroupInputSpecFromProto(groupInputSpecProto));
            }
        }
        TaskSpec taskSpec = new TaskSpec(taskAttemptID, vectorProto.getDagName(), vectorProto.getVertexName(), vectorProto.getVertexParallelism(), processorDescriptor, inputSpecList, outputSpecList, arrayList);
        return taskSpec;
    }

    public static TezTaskAttemptID createTaskAttemptId(LlapDaemonProtocolProtos.QueryIdentifierProto queryIdProto, int vertexIndex, int fragmentNum, int attemptNum) {
        return TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ConverterUtils.toApplicationId((String)queryIdProto.getApplicationIdString()), (int)queryIdProto.getDagIndex()), (int)vertexIndex), (int)fragmentNum), (int)attemptNum);
    }

    public static TezTaskAttemptID createTaskAttemptId(TaskContext ctx) {
        return TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ctx.getApplicationId(), (int)ctx.getDagIdentifier()), (int)ctx.getTaskVertexIndex()), (int)ctx.getTaskIndex()), (int)ctx.getTaskAttemptNumber());
    }

    public static LlapDaemonProtocolProtos.SignableVertexSpec.Builder constructSignableVertexSpec(TaskSpec taskSpec, LlapDaemonProtocolProtos.QueryIdentifierProto queryIdentifierProto, String tokenIdentifier, String user, String hiveQueryIdString) {
        TezTaskAttemptID tId = taskSpec.getTaskAttemptID();
        LlapDaemonProtocolProtos.SignableVertexSpec.Builder builder = LlapDaemonProtocolProtos.SignableVertexSpec.newBuilder();
        builder.setQueryIdentifier(queryIdentifierProto);
        builder.setHiveQueryId(hiveQueryIdString);
        builder.setVertexIndex(tId.getTaskID().getVertexID().getId());
        builder.setDagName(taskSpec.getDAGName());
        builder.setVertexName(taskSpec.getVertexName());
        builder.setVertexParallelism(taskSpec.getVertexParallelism());
        builder.setTokenIdentifier(tokenIdentifier);
        builder.setUser(user);
        if (taskSpec.getProcessorDescriptor() != null) {
            builder.setProcessorDescriptor(Converters.convertToProto(taskSpec.getProcessorDescriptor()));
        }
        if (taskSpec.getInputs() != null && !taskSpec.getInputs().isEmpty()) {
            for (InputSpec inputSpec : taskSpec.getInputs()) {
                builder.addInputSpecs(Converters.convertInputSpecToProto(inputSpec));
            }
        }
        if (taskSpec.getOutputs() != null && !taskSpec.getOutputs().isEmpty()) {
            for (OutputSpec outputSpec : taskSpec.getOutputs()) {
                builder.addOutputSpecs(Converters.convertOutputSpecToProto(outputSpec));
            }
        }
        if (taskSpec.getGroupInputs() != null && !taskSpec.getGroupInputs().isEmpty()) {
            for (GroupInputSpec groupInputSpec : taskSpec.getGroupInputs()) {
                builder.addGroupedInputSpecs(Converters.convertGroupInputSpecToProto(groupInputSpec));
            }
        }
        return builder;
    }

    private static ProcessorDescriptor convertProcessorDescriptorFromProto(LlapDaemonProtocolProtos.EntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = Converters.convertPayloadFromProto(proto);
        ProcessorDescriptor pd = ProcessorDescriptor.create((String)className);
        Converters.setUserPayload(pd, payload);
        return pd;
    }

    private static LlapDaemonProtocolProtos.EntityDescriptorProto convertToProto(EntityDescriptor<?> descriptor) {
        LlapDaemonProtocolProtos.EntityDescriptorProto.Builder builder = LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder();
        builder.setClassName(descriptor.getClassName());
        UserPayload userPayload = descriptor.getUserPayload();
        if (userPayload != null) {
            LlapDaemonProtocolProtos.UserPayloadProto.Builder payloadBuilder = LlapDaemonProtocolProtos.UserPayloadProto.newBuilder();
            if (userPayload.hasPayload()) {
                payloadBuilder.setUserPayload(UnsafeByteOperations.unsafeWrap((ByteBuffer)userPayload.getPayload()));
                payloadBuilder.setVersion(userPayload.getVersion());
            }
            builder.setUserPayload(payloadBuilder.build());
        }
        if (descriptor.getHistoryText() != null) {
            try {
                builder.setHistoryText(TezCommonUtils.compressByteArrayToByteString((byte[])descriptor.getHistoryText().getBytes("UTF-8")));
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
        return builder.build();
    }

    private static InputSpec getInputSpecFromProto(LlapDaemonProtocolProtos.IOSpecProto inputSpecProto) {
        InputDescriptor inputDescriptor = null;
        if (inputSpecProto.hasIoDescriptor()) {
            inputDescriptor = Converters.convertInputDescriptorFromProto(inputSpecProto.getIoDescriptor());
        }
        InputSpec inputSpec = new InputSpec(inputSpecProto.getConnectedVertexName(), inputDescriptor, inputSpecProto.getPhysicalEdgeCount());
        return inputSpec;
    }

    private static InputDescriptor convertInputDescriptorFromProto(LlapDaemonProtocolProtos.EntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = Converters.convertPayloadFromProto(proto);
        InputDescriptor id = InputDescriptor.create((String)className);
        Converters.setUserPayload(id, payload);
        return id;
    }

    private static OutputDescriptor convertOutputDescriptorFromProto(LlapDaemonProtocolProtos.EntityDescriptorProto proto) {
        String className = proto.getClassName();
        UserPayload payload = Converters.convertPayloadFromProto(proto);
        OutputDescriptor od = OutputDescriptor.create((String)className);
        Converters.setUserPayload(od, payload);
        return od;
    }

    private static LlapDaemonProtocolProtos.IOSpecProto convertInputSpecToProto(InputSpec inputSpec) {
        LlapDaemonProtocolProtos.IOSpecProto.Builder builder = LlapDaemonProtocolProtos.IOSpecProto.newBuilder();
        if (inputSpec.getSourceVertexName() != null) {
            builder.setConnectedVertexName(inputSpec.getSourceVertexName());
        }
        if (inputSpec.getInputDescriptor() != null) {
            builder.setIoDescriptor(Converters.convertToProto(inputSpec.getInputDescriptor()));
        }
        builder.setPhysicalEdgeCount(inputSpec.getPhysicalEdgeCount());
        return builder.build();
    }

    private static OutputSpec getOutputSpecFromProto(LlapDaemonProtocolProtos.IOSpecProto outputSpecProto) {
        OutputDescriptor outputDescriptor = null;
        if (outputSpecProto.hasIoDescriptor()) {
            outputDescriptor = Converters.convertOutputDescriptorFromProto(outputSpecProto.getIoDescriptor());
        }
        OutputSpec outputSpec = new OutputSpec(outputSpecProto.getConnectedVertexName(), outputDescriptor, outputSpecProto.getPhysicalEdgeCount());
        return outputSpec;
    }

    public static LlapDaemonProtocolProtos.IOSpecProto convertOutputSpecToProto(OutputSpec outputSpec) {
        LlapDaemonProtocolProtos.IOSpecProto.Builder builder = LlapDaemonProtocolProtos.IOSpecProto.newBuilder();
        if (outputSpec.getDestinationVertexName() != null) {
            builder.setConnectedVertexName(outputSpec.getDestinationVertexName());
        }
        if (outputSpec.getOutputDescriptor() != null) {
            builder.setIoDescriptor(Converters.convertToProto(outputSpec.getOutputDescriptor()));
        }
        builder.setPhysicalEdgeCount(outputSpec.getPhysicalEdgeCount());
        return builder.build();
    }

    private static GroupInputSpec getGroupInputSpecFromProto(LlapDaemonProtocolProtos.GroupInputSpecProto groupInputSpecProto) {
        GroupInputSpec groupSpec = new GroupInputSpec(groupInputSpecProto.getGroupName(), (List)groupInputSpecProto.getGroupVerticesList(), Converters.convertInputDescriptorFromProto(groupInputSpecProto.getMergedInputDescriptor()));
        return groupSpec;
    }

    private static LlapDaemonProtocolProtos.GroupInputSpecProto convertGroupInputSpecToProto(GroupInputSpec groupInputSpec) {
        LlapDaemonProtocolProtos.GroupInputSpecProto.Builder builder = LlapDaemonProtocolProtos.GroupInputSpecProto.newBuilder();
        builder.setGroupName(groupInputSpec.getGroupName());
        builder.addAllGroupVertices(groupInputSpec.getGroupVertices());
        builder.setMergedInputDescriptor(Converters.convertToProto(groupInputSpec.getMergedInputDescriptor()));
        return builder.build();
    }

    private static void setUserPayload(EntityDescriptor<?> entity, UserPayload payload) {
        if (payload != null) {
            entity.setUserPayload(payload);
        }
    }

    private static UserPayload convertPayloadFromProto(LlapDaemonProtocolProtos.EntityDescriptorProto proto) {
        UserPayload userPayload = null;
        if (proto.hasUserPayload()) {
            userPayload = proto.getUserPayload().hasUserPayload() ? UserPayload.create((ByteBuffer)proto.getUserPayload().getUserPayload().asReadOnlyByteBuffer(), (int)proto.getUserPayload().getVersion()) : UserPayload.create(null);
        }
        return userPayload;
    }

    public static LlapDaemonProtocolProtos.SourceStateProto fromVertexState(VertexState state) {
        switch (state) {
            case SUCCEEDED: {
                return LlapDaemonProtocolProtos.SourceStateProto.S_SUCCEEDED;
            }
            case RUNNING: {
                return LlapDaemonProtocolProtos.SourceStateProto.S_RUNNING;
            }
        }
        throw new RuntimeException("Unexpected state: " + state);
    }
}

