/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hudi.common.model;

import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Test;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Tests {@link FileSlice}.
 */
public class TestFileSlice {
  @Test
  void testGetLatestInstantTime() {
    String baseInstant = "003";
    String deltaInstant2 = "002";
    String deltaInstant4 = "004";

    FileSlice fileSlice = new FileSlice("par1", baseInstant, "fg1");
    assertThat(fileSlice.getLatestInstantTime(), is(baseInstant));

    fileSlice.addLogFile(new HoodieLogFile(new Path(getLogFileName(deltaInstant2))));
    assertThat(fileSlice.getLatestInstantTime(), is(baseInstant));

    fileSlice.addLogFile(new HoodieLogFile(new Path(getLogFileName(deltaInstant4))));
    assertThat(fileSlice.getLatestInstantTime(), is(deltaInstant4));
  }

  private static String getLogFileName(String instantTime) {
    return ".fg1_" + instantTime + ".log.1_1-0-1";
  }
}
