/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.schemas.network.InboundView;
import org.apache.ignite.configuration.schemas.network.NetworkConfiguration;
import org.apache.ignite.configuration.schemas.network.NetworkView;
import org.apache.ignite.configuration.schemas.network.OutboundView;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.netty.NamedNioEventLoopGroup;

public class NettyBootstrapFactory
implements IgniteComponent {
    private final NetworkConfiguration networkConfiguration;
    private final String eventLoopGroupNamePrefix;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private EventLoopGroup clientWorkerGroup;

    public NettyBootstrapFactory(NetworkConfiguration networkConfiguration, String eventLoopGroupNamePrefix) {
        assert (eventLoopGroupNamePrefix != null);
        assert (networkConfiguration != null);
        this.networkConfiguration = networkConfiguration;
        this.eventLoopGroupNamePrefix = eventLoopGroupNamePrefix;
    }

    public Bootstrap createClientBootstrap() {
        OutboundView clientConfiguration = ((NetworkView)this.networkConfiguration.value()).outbound();
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)clientBootstrap.group(this.clientWorkerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)clientConfiguration.soKeepAlive())).option(ChannelOption.SO_LINGER, (Object)clientConfiguration.soLinger())).option(ChannelOption.TCP_NODELAY, (Object)clientConfiguration.tcpNoDelay());
        return clientBootstrap;
    }

    public ServerBootstrap createServerBootstrap() {
        InboundView serverConfiguration = ((NetworkView)this.networkConfiguration.value()).inbound();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)serverConfiguration.soBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)serverConfiguration.soReuseAddr())).childOption(ChannelOption.SO_KEEPALIVE, (Object)serverConfiguration.soKeepAlive()).childOption(ChannelOption.SO_LINGER, (Object)serverConfiguration.soLinger()).childOption(ChannelOption.TCP_NODELAY, (Object)serverConfiguration.tcpNoDelay());
        return serverBootstrap;
    }

    public void start() {
        this.bossGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-srv-accept");
        this.workerGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-srv-worker");
        this.clientWorkerGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-client");
    }

    public static boolean isInNetworkThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof NamedNioEventLoopGroup.NetworkThread;
    }

    public void stop() throws Exception {
        NetworkView configurationView = (NetworkView)this.networkConfiguration.value();
        long quietPeriod = configurationView.shutdownQuietPeriod();
        long shutdownTimeout = configurationView.shutdownTimeout();
        this.clientWorkerGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
        this.workerGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
        this.bossGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
    }
}

