/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.HashIndexDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.HashUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;

public class RocksDbHashIndexStorage
implements HashIndexStorage {
    public static final int FIXED_PREFIX_LENGTH = 22;
    private final HashIndexDescriptor descriptor;
    private final ColumnFamily indexCf;
    private final RocksDbMvPartitionStorage partitionStorage;
    private final byte[] constantPrefix;

    public RocksDbHashIndexStorage(HashIndexDescriptor descriptor, ColumnFamily indexCf, RocksDbMvPartitionStorage partitionStorage) {
        this.descriptor = descriptor;
        this.indexCf = indexCf;
        this.partitionStorage = partitionStorage;
        UUID indexId = descriptor.id();
        this.constantPrefix = ByteBuffer.allocate(18).order(ByteOrder.BIG_ENDIAN).putLong(indexId.getMostSignificantBits()).putLong(indexId.getLeastSignificantBits()).putShort((short)partitionStorage.partitionId()).array();
    }

    public HashIndexDescriptor indexDescriptor() {
        return this.descriptor;
    }

    public Cursor<RowId> get(BinaryTuple key) {
        byte[] rangeStart = this.rocksPrefix(key);
        byte[] rangeEnd = RocksUtils.incrementArray((byte[])rangeStart);
        final Slice upperBound = rangeEnd == null ? null : new Slice(rangeEnd);
        final ReadOptions options = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBound);
        RocksIterator it = this.indexCf.newIterator(options);
        it.seek(rangeStart);
        return new RocksIteratorAdapter<RowId>(it){

            protected RowId decodeEntry(byte[] key, byte[] value) {
                long mostSignificantBits = ByteUtils.bytesToLong((byte[])key, (int)(key.length - 16));
                long leastSignificantBits = ByteUtils.bytesToLong((byte[])key, (int)(key.length - 8));
                return new RowId(RocksDbHashIndexStorage.this.partitionStorage.partitionId(), mostSignificantBits, leastSignificantBits);
            }

            public void close() throws Exception {
                super.close();
                IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{options, upperBound});
            }
        };
    }

    public void put(IndexRow row) {
        WriteBatchWithIndex writeBatch = this.partitionStorage.currentWriteBatch();
        try {
            writeBatch.put(this.indexCf.handle(), this.rocksKey(row), ArrayUtils.BYTE_EMPTY_ARRAY);
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to insert data into hash index. Index ID: " + this.descriptor.id(), (Throwable)e);
        }
    }

    public void remove(IndexRow row) {
        WriteBatchWithIndex writeBatch = this.partitionStorage.currentWriteBatch();
        try {
            writeBatch.delete(this.indexCf.handle(), this.rocksKey(row));
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to remove data from hash index. Index ID: " + this.descriptor.id(), (Throwable)e);
        }
    }

    public void destroy() {
        byte[] rangeEnd = RocksUtils.incrementArray((byte[])this.constantPrefix);
        assert (rangeEnd != null);
        try (WriteOptions writeOptions = new WriteOptions().setDisableWAL(true);){
            this.indexCf.db().deleteRange(this.indexCf.handle(), writeOptions, this.constantPrefix, rangeEnd);
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to remove data from hash index. Index ID: " + this.descriptor.id(), (Throwable)e);
        }
    }

    private byte[] rocksPrefix(BinaryTuple prefix) {
        return this.rocksPrefix(prefix, 0).array();
    }

    private ByteBuffer rocksPrefix(BinaryTuple prefix, int extraLength) {
        ByteBuffer keyBytes = prefix.byteBuffer();
        return ByteBuffer.allocate(22 + keyBytes.remaining() + extraLength).order(ByteOrder.BIG_ENDIAN).put(this.constantPrefix).putInt(HashUtils.hash32((ByteBuffer)keyBytes)).put(keyBytes);
    }

    private byte[] rocksKey(IndexRow row) {
        RowId rowId = row.rowId();
        return this.rocksPrefix(row.indexColumns(), 16).putLong(rowId.mostSignificantBits()).putLong(rowId.leastSignificantBits()).array();
    }
}

