/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.List;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ClientSqlColumnTypeConverter;
import org.apache.ignite.internal.client.sql.ClientColumnOrigin;
import org.apache.ignite.internal.sql.SqlColumnTypeConverter;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.SqlColumnType;

public class ClientColumnMetadata
implements ColumnMetadata {
    private final String name;
    private final SqlColumnType type;
    private final boolean nullable;
    private final int precision;
    private final int scale;
    private final ColumnMetadata.ColumnOrigin origin;

    public ClientColumnMetadata(ClientMessageUnpacker unpacker, List<ColumnMetadata> prevColumns) {
        this.name = unpacker.unpackString();
        this.nullable = unpacker.unpackBoolean();
        this.type = ClientSqlColumnTypeConverter.ordinalToColumnType((int)unpacker.unpackInt());
        this.scale = unpacker.unpackInt();
        this.precision = unpacker.unpackInt();
        this.origin = unpacker.unpackBoolean() ? new ClientColumnOrigin(unpacker, this.name, prevColumns) : null;
    }

    public String name() {
        return this.name;
    }

    public Class<?> valueClass() {
        return SqlColumnTypeConverter.columnTypeToClass((SqlColumnType)this.type);
    }

    public SqlColumnType type() {
        return this.type;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public ColumnMetadata.ColumnOrigin origin() {
        return this.origin;
    }
}

