/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.cli.core.style.element.UiElements;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.InvalidParam;
import org.apache.ignite.rest.client.model.Problem;
import org.jetbrains.annotations.NotNull;

public class IgniteCliApiExceptionHandler
implements ExceptionHandler<IgniteCliApiException> {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteCliApiExceptionHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public int handle(ExceptionWriter err, IgniteCliApiException e) {
        ErrorUiComponent.ErrorComponentBuilder errorComponentBuilder = ErrorUiComponent.builder();
        if (e.getCause() instanceof ApiException) {
            ApiException cause = (ApiException)e.getCause();
            Throwable apiCause = cause.getCause();
            if (apiCause instanceof UnknownHostException) {
                errorComponentBuilder.header("Unknown host: %s", UiElements.url(e.getUrl())).verbose(apiCause.getMessage(), new UiElement[0]);
            } else if (apiCause instanceof ConnectException) {
                errorComponentBuilder.header("Node unavailable", new UiElement[0]).details("Could not connect to node with URL %s", UiElements.url(e.getUrl())).verbose(apiCause.getMessage(), new UiElement[0]);
            } else if (apiCause != null) {
                errorComponentBuilder.header(apiCause.getMessage(), new UiElement[0]);
            } else {
                IgniteCliApiExceptionHandler.tryToExtractProblem(errorComponentBuilder, cause);
            }
        } else {
            errorComponentBuilder.header(e.getCause() != e ? e.getCause().getMessage() : e.getMessage(), new UiElement[0]);
        }
        ErrorUiComponent errorComponent = errorComponentBuilder.build();
        LOG.error(errorComponent.header(), (Throwable)e);
        err.write(errorComponent.render());
        return 1;
    }

    private static void tryToExtractProblem(ErrorUiComponent.ErrorComponentBuilder errorComponentBuilder, ApiException cause) {
        try {
            Problem problem = (Problem)objectMapper.readValue(cause.getResponseBody(), Problem.class);
            List<InvalidParam> invalidParams = problem.getInvalidParams();
            if (invalidParams != null && !invalidParams.isEmpty()) {
                errorComponentBuilder.details(IgniteCliApiExceptionHandler.extractInvalidParams(invalidParams), new UiElement[0]);
            }
            errorComponentBuilder.header(problem.getDetail() != null ? problem.getDetail() : problem.getTitle(), new UiElement[0]).errorCode(problem.getCode()).traceId(problem.getTraceId());
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static String extractInvalidParams(List<InvalidParam> invalidParams) {
        return invalidParams.stream().map(invalidParam -> invalidParam.getName() + ": " + invalidParam.getReason()).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public Class<IgniteCliApiException> applicableException() {
        return IgniteCliApiException.class;
    }
}

