/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.config;

import java.io.File;
import java.io.IOException;
import org.apache.ignite.internal.cli.config.Config;
import org.apache.ignite.internal.cli.config.ConfigInitializationException;
import org.apache.ignite.internal.cli.config.ini.IniConfig;
import org.apache.ignite.internal.cli.config.ini.IniFile;

public class StateConfig {
    public static Config getStateConfig(File file) {
        IniFile iniFile = StateConfig.loadStateConfig(file);
        return new IniConfig(iniFile.getTopLevelSection(), iniFile::store);
    }

    private static IniFile loadStateConfig(File file) {
        try {
            return new IniFile(file);
        }
        catch (IOException e) {
            return StateConfig.createDefaultConfig(file);
        }
    }

    private static IniFile createDefaultConfig(File file) {
        try {
            file.getParentFile().mkdirs();
            file.delete();
            file.createNewFile();
            IniFile ini = new IniFile(file);
            ini.store();
            return ini;
        }
        catch (IOException e) {
            throw new ConfigInitializationException(file.getAbsolutePath(), e);
        }
    }
}

