/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.EnumSet;
import org.apache.ignite.client.ClientFeatureNotSupportedByServerException;
import org.apache.ignite.internal.client.thin.ProtocolBitmaskFeature;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.client.thin.ProtocolVersionFeature;
import org.apache.ignite.internal.util.typedef.internal.S;

public class ProtocolContext {
    private final ProtocolVersion ver;
    private final EnumSet<ProtocolBitmaskFeature> features;

    public ProtocolContext(ProtocolVersion ver) {
        this(ver, null);
    }

    public ProtocolContext(ProtocolVersion ver, EnumSet<ProtocolBitmaskFeature> features) {
        this.ver = ver;
        this.features = features != null ? features : EnumSet.noneOf(ProtocolBitmaskFeature.class);
    }

    public boolean isFeatureSupported(ProtocolBitmaskFeature feature) {
        return this.features.contains((Object)feature);
    }

    public void checkFeatureSupported(ProtocolBitmaskFeature feature) throws ClientFeatureNotSupportedByServerException {
        if (!this.isFeatureSupported(feature)) {
            throw new ClientFeatureNotSupportedByServerException(feature);
        }
    }

    public boolean isFeatureSupported(ProtocolVersionFeature feature) {
        return ProtocolContext.isFeatureSupported(this.ver, feature);
    }

    public EnumSet<ProtocolBitmaskFeature> features() {
        return this.features;
    }

    public ProtocolVersion version() {
        return this.ver;
    }

    public static boolean isFeatureSupported(ProtocolVersion ver, ProtocolVersionFeature feature) {
        return ver.compareTo(feature.verIntroduced()) >= 0;
    }

    public String toString() {
        return S.toString(ProtocolContext.class.getSimpleName(), "version", (Object)this.version(), false, "features", (Object)this.features.toString(), false);
    }
}

