/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.platform.dotnet;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.platform.dotnet.PlatformDotNetBinaryTypeConfiguration;

public class PlatformDotNetBinaryConfiguration {
    private Collection<PlatformDotNetBinaryTypeConfiguration> typesCfg;
    private Collection<String> types;
    private String dfltNameMapper;
    private String dfltIdMapper;
    private String dfltSerializer;
    private boolean dfltKeepDeserialized = true;

    public PlatformDotNetBinaryConfiguration() {
    }

    public PlatformDotNetBinaryConfiguration(PlatformDotNetBinaryConfiguration cfg) {
        if (cfg.getTypesConfiguration() != null) {
            this.typesCfg = new ArrayList<PlatformDotNetBinaryTypeConfiguration>();
            for (PlatformDotNetBinaryTypeConfiguration typeCfg : cfg.getTypesConfiguration()) {
                this.typesCfg.add(new PlatformDotNetBinaryTypeConfiguration(typeCfg));
            }
        }
        if (cfg.getTypes() != null) {
            this.types = new ArrayList<String>(cfg.getTypes());
        }
        this.dfltNameMapper = cfg.getDefaultNameMapper();
        this.dfltIdMapper = cfg.getDefaultIdMapper();
        this.dfltSerializer = cfg.getDefaultSerializer();
        this.dfltKeepDeserialized = cfg.isDefaultKeepDeserialized();
    }

    public Collection<PlatformDotNetBinaryTypeConfiguration> getTypesConfiguration() {
        return this.typesCfg;
    }

    public PlatformDotNetBinaryConfiguration setTypesConfiguration(Collection<PlatformDotNetBinaryTypeConfiguration> typesCfg) {
        this.typesCfg = typesCfg;
        return this;
    }

    public Collection<String> getTypes() {
        return this.types;
    }

    public PlatformDotNetBinaryConfiguration setTypes(Collection<String> types) {
        this.types = types;
        return this;
    }

    public String getDefaultNameMapper() {
        return this.dfltNameMapper;
    }

    public PlatformDotNetBinaryConfiguration setDefaultNameMapper(String dfltNameMapper) {
        this.dfltNameMapper = dfltNameMapper;
        return this;
    }

    public String getDefaultIdMapper() {
        return this.dfltIdMapper;
    }

    public PlatformDotNetBinaryConfiguration setDefaultIdMapper(String dfltIdMapper) {
        this.dfltIdMapper = dfltIdMapper;
        return this;
    }

    public String getDefaultSerializer() {
        return this.dfltSerializer;
    }

    public PlatformDotNetBinaryConfiguration setDefaultSerializer(String dfltSerializer) {
        this.dfltSerializer = dfltSerializer;
        return this;
    }

    public boolean isDefaultKeepDeserialized() {
        return this.dfltKeepDeserialized;
    }

    public PlatformDotNetBinaryConfiguration setDefaultKeepDeserialized(boolean keepDeserialized) {
        this.dfltKeepDeserialized = keepDeserialized;
        return this;
    }

    public String toString() {
        return S.toString(PlatformDotNetBinaryConfiguration.class, this);
    }
}

