/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.ea.unpadded;

import java.util.Iterator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MessagePassingQueueUtil;
import org.jctools.queues.ea.unpadded.MpscUnpaddedArrayQueue;
import org.jctools.queues.ea.unpadded.MpscUnpaddedCompoundQueueConsumerQueueIndex;
import org.jctools.util.PortableJvmInfo;

public class MpscUnpaddedCompoundQueue<E>
extends MpscUnpaddedCompoundQueueConsumerQueueIndex<E> {
    public MpscUnpaddedCompoundQueue(int capacity) {
        this(capacity, PortableJvmInfo.CPUs);
    }

    public MpscUnpaddedCompoundQueue(int capacity, int queueParallelism) {
        super(capacity, queueParallelism);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscUnpaddedArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].offer(e)) {
            return true;
        }
        return this.slowOffer(queues, parallelQueuesMask, start + 1, e);
    }

    private boolean slowOffer(MpscUnpaddedArrayQueue<E>[] queues, int parallelQueuesMask, int start, E e) {
        int status;
        int queueCount = parallelQueuesMask + 1;
        int end = start + queueCount;
        do {
            status = 0;
            for (int i = start; i < end; ++i) {
                int s = queues[i & parallelQueuesMask].failFastOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
            }
        } while (status != queueCount);
        return false;
    }

    @Override
    public E poll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].poll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E peek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].peek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int size() {
        int size = 0;
        for (MpscUnpaddedArrayQueue lane : this.queues) {
            size += lane.size();
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscUnpaddedArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].failFastOffer(e) == 0) {
            return true;
        }
        for (int i = start + 1; i < start + parallelQueuesMask + 1; ++i) {
            if (queues[i & parallelQueuesMask].failFastOffer(e) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public E relaxedPoll() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPoll()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E relaxedPeek() {
        int qIndex;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        for (qIndex = this.consumerQueueIndex & this.parallelQueuesMask; qIndex < limit && (e = (E)this.queues[qIndex & this.parallelQueuesMask].relaxedPeek()) == null; ++qIndex) {
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int capacity() {
        return this.queues.length * this.queues[0].capacity();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int limit = this.capacity();
        return this.drain(c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return MessagePassingQueueUtil.fillBounded(this, s);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscUnpaddedArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        int filled = queues[start].fill(s, limit);
        if (filled == limit) {
            return limit;
        }
        for (int i = start + 1; i < start + parallelQueuesMask + 1; ++i) {
            if ((filled += queues[i & parallelQueuesMask].fill(s, limit - filled)) != limit) continue;
            return limit;
        }
        return filled;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, wait, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s, wait, exit);
    }
}

