/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class MbLayer {
    @Valid
    private String id;
    @Valid
    private TypeEnum type;
    @Valid
    private List<Object> filter = new ArrayList<Object>();
    @Valid
    private String source;
    @Valid
    private String sourceLayer;
    @Valid
    private Object layout;
    @Valid
    private BigDecimal minzoom;
    @Valid
    private BigDecimal maxzoom;
    @Valid
    private Object paint;

    public MbLayer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MbLayer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="fill", required=true, value="")
    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public MbLayer filter(List<Object> filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="filter")
    public List<Object> getFilter() {
        return this.filter;
    }

    public void setFilter(List<Object> filter) {
        this.filter = filter;
    }

    public MbLayer source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="daraa", value="")
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public MbLayer sourceLayer(String sourceLayer) {
        this.sourceLayer = sourceLayer;
        return this;
    }

    @ApiModelProperty(example="vegetationsrf", value="")
    @JsonProperty(value="source-layer")
    public String getSourceLayer() {
        return this.sourceLayer;
    }

    public void setSourceLayer(String sourceLayer) {
        this.sourceLayer = sourceLayer;
    }

    public MbLayer layout(Object layout) {
        this.layout = layout;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="layout")
    public Object getLayout() {
        return this.layout;
    }

    public void setLayout(Object layout) {
        this.layout = layout;
    }

    public MbLayer minzoom(BigDecimal minzoom) {
        this.minzoom = minzoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="minzoom")
    public BigDecimal getMinzoom() {
        return this.minzoom;
    }

    public void setMinzoom(BigDecimal minzoom) {
        this.minzoom = minzoom;
    }

    public MbLayer maxzoom(BigDecimal maxzoom) {
        this.maxzoom = maxzoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="maxzoom")
    public BigDecimal getMaxzoom() {
        return this.maxzoom;
    }

    public void setMaxzoom(BigDecimal maxzoom) {
        this.maxzoom = maxzoom;
    }

    public MbLayer paint(Object paint) {
        this.paint = paint;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paint")
    public Object getPaint() {
        return this.paint;
    }

    public void setPaint(Object paint) {
        this.paint = paint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MbLayer mbLayer = (MbLayer)o;
        return Objects.equals(this.id, mbLayer.id) && Objects.equals((Object)this.type, (Object)mbLayer.type) && Objects.equals(this.filter, mbLayer.filter) && Objects.equals(this.source, mbLayer.source) && Objects.equals(this.sourceLayer, mbLayer.sourceLayer) && Objects.equals(this.layout, mbLayer.layout) && Objects.equals(this.minzoom, mbLayer.minzoom) && Objects.equals(this.maxzoom, mbLayer.maxzoom) && Objects.equals(this.paint, mbLayer.paint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.filter, this.source, this.sourceLayer, this.layout, this.minzoom, this.maxzoom, this.paint});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MbLayer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    sourceLayer: ").append(this.toIndentedString(this.sourceLayer)).append("\n");
        sb.append("    layout: ").append(this.toIndentedString(this.layout)).append("\n");
        sb.append("    minzoom: ").append(this.toIndentedString(this.minzoom)).append("\n");
        sb.append("    maxzoom: ").append(this.toIndentedString(this.maxzoom)).append("\n");
        sb.append("    paint: ").append(this.toIndentedString(this.paint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FILL(String.valueOf("fill")),
        LINE(String.valueOf("line")),
        SYMBOL(String.valueOf("symbol")),
        CIRCLE(String.valueOf("circle")),
        HEATMAP(String.valueOf("heatmap")),
        FILL_EXTRUSION(String.valueOf("fill-extrusion")),
        RASTER(String.valueOf("raster")),
        HILLSHADE(String.valueOf("hillshade")),
        BACKGROUND(String.valueOf("background"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

