/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.model.MbLayer;
import org.apache.baremaps.model.MbStyleSources;

public class MbStyle {
    @Valid
    private BigDecimal version;
    @Valid
    private String name;
    @Valid
    private Map<String, MbStyleSources> sources = new HashMap<String, MbStyleSources>();
    @Valid
    private String sprite;
    @Valid
    private String glyphs;
    @Valid
    private List<MbLayer> layers = new ArrayList<MbLayer>();
    @Valid
    private List<BigDecimal> center = new ArrayList<BigDecimal>();
    @Valid
    private Object metadata;
    @Valid
    private BigDecimal zoom;

    public MbStyle version(BigDecimal version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="8", required=true, value="")
    @JsonProperty(value="version")
    @NotNull
    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public MbStyle name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="night", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MbStyle sources(Map<String, MbStyleSources> sources) {
        this.sources = sources;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sources")
    @NotNull
    public Map<String, MbStyleSources> getSources() {
        return this.sources;
    }

    public void setSources(Map<String, MbStyleSources> sources) {
        this.sources = sources;
    }

    public MbStyle sprite(String sprite) {
        this.sprite = sprite;
        return this;
    }

    @ApiModelProperty(example="http://vtp2018.s3-eu-west-1.amazonaws.com/static/mapstorestyle/sprites/sprites", value="")
    @JsonProperty(value="sprite")
    public String getSprite() {
        return this.sprite;
    }

    public void setSprite(String sprite) {
        this.sprite = sprite;
    }

    public MbStyle glyphs(String glyphs) {
        this.glyphs = glyphs;
        return this;
    }

    @ApiModelProperty(example="http://fonts.openmaptiles.org/{fontstack}/{range}.pbf", value="")
    @JsonProperty(value="glyphs")
    public String getGlyphs() {
        return this.glyphs;
    }

    public void setGlyphs(String glyphs) {
        this.glyphs = glyphs;
    }

    public MbStyle layers(List<MbLayer> layers) {
        this.layers = layers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="layers")
    @NotNull
    public List<MbLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<MbLayer> layers) {
        this.layers = layers;
    }

    public MbStyle center(List<BigDecimal> center) {
        this.center = center;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="center")
    public List<BigDecimal> getCenter() {
        return this.center;
    }

    public void setCenter(List<BigDecimal> center) {
        this.center = center;
    }

    public MbStyle metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public MbStyle zoom(BigDecimal zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="zoom")
    public BigDecimal getZoom() {
        return this.zoom;
    }

    public void setZoom(BigDecimal zoom) {
        this.zoom = zoom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MbStyle mbStyle = (MbStyle)o;
        return Objects.equals(this.version, mbStyle.version) && Objects.equals(this.name, mbStyle.name) && Objects.equals(this.sources, mbStyle.sources) && Objects.equals(this.sprite, mbStyle.sprite) && Objects.equals(this.glyphs, mbStyle.glyphs) && Objects.equals(this.layers, mbStyle.layers) && Objects.equals(this.center, mbStyle.center) && Objects.equals(this.metadata, mbStyle.metadata) && Objects.equals(this.zoom, mbStyle.zoom);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.name, this.sources, this.sprite, this.glyphs, this.layers, this.center, this.metadata, this.zoom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MbStyle {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    sprite: ").append(this.toIndentedString(this.sprite)).append("\n");
        sb.append("    glyphs: ").append(this.toIndentedString(this.glyphs)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    center: ").append(this.toIndentedString(this.center)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

