/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.wkt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.crs.CRSException;

public class TextReader {
    private static final Logger logger = Logger.getLogger(TextReader.class.getName());
    private final Reader reader;
    private final List<String> nextTokens = new ArrayList<String>();
    private Integer nextCharacterNum;
    private boolean includeQuotes = false;

    public TextReader(String text) {
        this(new StringReader(text));
    }

    public TextReader(Reader reader) {
        this(reader, false);
    }

    public TextReader(String text, boolean includeQuotes) {
        this(new StringReader(text), includeQuotes);
    }

    public TextReader(Reader reader, boolean includeQuotes) {
        this.reader = reader;
        this.includeQuotes = includeQuotes;
    }

    public Reader getReader() {
        return this.reader;
    }

    public boolean isIncludeQuotes() {
        return this.includeQuotes;
    }

    public void setIncludeQuotes(boolean includeQuotes) {
        this.includeQuotes = includeQuotes;
    }

    public void reset() throws IOException {
        this.reader.reset();
        this.nextTokens.clear();
        this.nextCharacterNum = null;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close text reader", e);
        }
    }

    public String readToken() throws IOException {
        return this.readToken(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readToken(boolean cache) throws IOException {
        int characterNum;
        Object token = null;
        if (cache && !this.nextTokens.isEmpty()) {
            return this.nextTokens.remove(0);
        }
        StringBuilder builder = null;
        boolean isQuote = false;
        boolean previousCharQuote = false;
        if (this.nextCharacterNum != null) {
            characterNum = this.nextCharacterNum;
            this.nextCharacterNum = null;
        } else {
            characterNum = this.reader.read();
        }
        while (characterNum != -1) {
            block16: {
                char character;
                block17: {
                    character = (char)characterNum;
                    if (builder == null) break block17;
                    if (isQuote) {
                        boolean charQuote = TextReader.isQuoteCharacter(character);
                        if (previousCharQuote) {
                            if (charQuote) {
                                builder.append(character);
                                previousCharQuote = false;
                                break block16;
                            } else {
                                this.nextCharacterNum = characterNum;
                                break;
                            }
                        }
                        if (charQuote) {
                            previousCharQuote = true;
                            break block16;
                        } else {
                            builder.append(character);
                        }
                        break block16;
                    } else if (TextReader.isTokenCharacter(character)) {
                        builder.append(character);
                        break block16;
                    } else {
                        if (TextReader.isWhitespace(character)) break;
                        this.nextCharacterNum = characterNum;
                        break;
                    }
                }
                if (!TextReader.isWhitespace(character)) {
                    builder = new StringBuilder();
                    if (TextReader.isQuoteCharacter(character)) {
                        isQuote = true;
                    } else {
                        builder.append(character);
                        if (!TextReader.isTokenCharacter(character)) break;
                    }
                }
            }
            characterNum = this.reader.read();
        }
        if (builder == null) return token;
        token = builder.toString();
        if (!isQuote) return token;
        if (!this.includeQuotes) return token;
        return "\"" + (String)token + "\"";
    }

    public String peekToken() throws IOException {
        return this.peekToken(1);
    }

    public String peekToken(int num) throws IOException {
        for (int i = 1; i <= num; ++i) {
            if (this.nextTokens.size() >= i) continue;
            String token = this.readToken(false);
            if (token == null) break;
            this.nextTokens.add(token);
        }
        String token = null;
        if (num <= this.nextTokens.size()) {
            token = this.nextTokens.get(num - 1);
        }
        return token;
    }

    public void pushToken(String token) {
        this.nextTokens.add(0, token);
    }

    public String readExpectedToken() throws IOException {
        String token = this.readToken();
        if (token == null) {
            throw new CRSException("Unexpected end of text, null token");
        }
        return token;
    }

    public String peekExpectedToken() throws IOException {
        return this.peekExpectedToken(1);
    }

    public String peekExpectedToken(int num) throws IOException {
        String token = this.peekToken(num);
        if (token == null) {
            throw new CRSException("Unexpected end of text, null token");
        }
        return token;
    }

    public double readNumber() throws IOException {
        double number;
        String token = this.readExpectedToken();
        try {
            number = Double.parseDouble(token);
        }
        catch (NumberFormatException e) {
            throw new CRSException("Invalid number token. found: '" + token + "'", e);
        }
        return number;
    }

    public double readUnsignedNumber() throws IOException {
        double number = this.readNumber();
        if (number < 0.0) {
            throw new CRSException("Invalid unsigned number. found: " + number);
        }
        return number;
    }

    public int readInteger() throws IOException {
        int number;
        String token = this.readExpectedToken();
        try {
            number = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new CRSException("Invalid integer token. found: '" + token + "'", e);
        }
        return number;
    }

    public int readUnsignedInteger() throws IOException {
        int number;
        String token = this.readExpectedToken();
        try {
            number = Integer.parseUnsignedInt(token);
        }
        catch (NumberFormatException e) {
            throw new CRSException("Invalid unsigned integer token. found: '" + token + "'", e);
        }
        return number;
    }

    public static boolean isTokenCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '+' || c == ':' || c == '_';
    }

    public static boolean isQuoteCharacter(char c) {
        boolean quote;
        boolean bl = quote = c == '\"';
        if (!quote) {
            int type = Character.getType(c);
            quote = type == 29 || type == 30;
        }
        return quote;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }
}

