/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.api.FromIterablePublisher;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherAsBlockingIterable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

final class FromBlockingIterablePublisher<T>
extends AbstractSynchronousPublisher<T> {
    private final BlockingIterable<? extends T> iterable;
    private final LongSupplier timeoutSupplier;
    private final TimeUnit unit;

    private FromBlockingIterablePublisher(BlockingIterable<? extends T> iterable, LongSupplier timeoutSupplier, TimeUnit unit) {
        this.iterable = Objects.requireNonNull(iterable);
        this.timeoutSupplier = Objects.requireNonNull(timeoutSupplier);
        this.unit = Objects.requireNonNull(unit);
    }

    static <T> Publisher<T> fromBlockingIterable0(BlockingIterable<? extends T> iterable, LongSupplier timeoutSupplier, TimeUnit unit) {
        return iterable instanceof PublisherAsBlockingIterable ? ((PublisherAsBlockingIterable)iterable).original : new FromBlockingIterablePublisher<T>(iterable, timeoutSupplier, unit);
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(new FromBlockingIterableSubscription<T>(this.iterable.iterator(), subscriber, this));
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
        }
    }

    private static final class FromBlockingIterableSubscription<T>
    extends FromIterablePublisher.FromIterableSubscription<T, BlockingIterator<? extends T>> {
        private final FromBlockingIterablePublisher<T> iterablePublisher;

        FromBlockingIterableSubscription(BlockingIterator<? extends T> iterator, PublisherSource.Subscriber<? super T> subscriber, FromBlockingIterablePublisher<T> iterablePublisher) {
            super(iterator, subscriber);
            this.iterablePublisher = iterablePublisher;
        }

        @Override
        boolean hasNext(BlockingIterator<? extends T> iterator) throws TimeoutException {
            return iterator.hasNext(((FromBlockingIterablePublisher)this.iterablePublisher).timeoutSupplier.getAsLong(), ((FromBlockingIterablePublisher)this.iterablePublisher).unit);
        }

        @Override
        @Nullable
        T next(BlockingIterator<? extends T> iterator) throws TimeoutException {
            return (T)iterator.next(((FromBlockingIterablePublisher)this.iterablePublisher).timeoutSupplier.getAsLong(), ((FromBlockingIterablePublisher)this.iterablePublisher).unit);
        }
    }
}

