/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

abstract class MulticastLeafSubscriber<T>
implements PublisherSource.Subscriber<T>,
PublisherSource.Subscription {
    private static final AtomicLongFieldUpdater<MulticastLeafSubscriber> requestedUpdater = AtomicLongFieldUpdater.newUpdater(MulticastLeafSubscriber.class, "requested");
    private static final AtomicLongFieldUpdater<MulticastLeafSubscriber> sourceRequestedUpdater = AtomicLongFieldUpdater.newUpdater(MulticastLeafSubscriber.class, "sourceRequested");
    private static final AtomicLongFieldUpdater<MulticastLeafSubscriber> sourceEmittedUpdater = AtomicLongFieldUpdater.newUpdater(MulticastLeafSubscriber.class, "sourceEmitted");
    private static final AtomicIntegerFieldUpdater<MulticastLeafSubscriber> emittingLockUpdater = AtomicIntegerFieldUpdater.newUpdater(MulticastLeafSubscriber.class, "emittingLock");
    @Nullable
    private Queue<Object> signalQueue;
    private volatile long requested;
    private volatile long sourceRequested;
    private volatile long sourceEmitted;
    private volatile int emittingLock;
    private boolean cancelled;

    MulticastLeafSubscriber() {
        ConcurrentUtils.tryAcquireLock(emittingLockUpdater, (Object)this);
    }

    @Nullable
    abstract PublisherSource.Subscriber<? super T> subscriber();

    @Nullable
    abstract PublisherSource.Subscriber<? super T> subscriberOnSubscriptionThread();

    abstract void requestUpstream(long var1);

    abstract void cancelUpstream();

    abstract int outstandingDemandLimit();

    final void triggerOnSubscribe() {
        PublisherSource.Subscriber<T> subscriber = this.subscriberOnSubscriptionThread();
        assert (subscriber != null);
        try {
            subscriber.onSubscribe((PublisherSource.Subscription)this);
        }
        finally {
            if (!ConcurrentUtils.releaseLock(emittingLockUpdater, (Object)this)) {
                this.drainSignalQueue(subscriber);
            }
        }
    }

    public final void request(long n) {
        if (this.cancelled) {
            return;
        }
        if (SubscriberUtils.isRequestNValid((long)n)) {
            requestedUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtection);
            this.drainSignalQueueSupplier(this.subscriberOnSubscriptionThread(), this::subscriberOnSubscriptionThread);
        } else {
            this.requestUpstream(n);
        }
    }

    public final void cancel() {
        this.cancelled = true;
        this.cancelUpstream();
    }

    public final void onSubscribe(PublisherSource.Subscription subscription) {
        throw new UnsupportedOperationException();
    }

    public final void onNext(@Nullable T t) {
        PublisherSource.Subscriber<T> subscriber = this.subscriber();
        if (subscriber == null) {
            this.getOrCreateSignalQueue(8).add(SubscriberApiUtils.wrapNull(t));
            this.drainSignalQueueSupplier(null, this::subscriber);
        } else if (this.hasSignalsQueued()) {
            this.getOrCreateSignalQueue(8).add(SubscriberApiUtils.wrapNull(t));
            this.drainSignalQueue(subscriber);
        } else if (ConcurrentUtils.tryAcquireLock(emittingLockUpdater, (Object)this)) {
            if (this.sourceEmitted < this.requested) {
                try {
                    sourceEmittedUpdater.getAndIncrement(this);
                    subscriber.onNext(t);
                }
                finally {
                    if (ConcurrentUtils.releaseLock(emittingLockUpdater, (Object)this)) {
                        this.updateRequestN();
                    } else {
                        this.drainSignalQueue(subscriber);
                    }
                }
            } else {
                ConcurrentUtils.releaseLock(emittingLockUpdater, (Object)this);
                this.getOrCreateSignalQueue(8).add(SubscriberApiUtils.wrapNull(t));
                this.drainSignalQueue(subscriber);
            }
        } else {
            this.getOrCreateSignalQueue(8).add(SubscriberApiUtils.wrapNull(t));
            this.drainSignalQueue(subscriber);
        }
    }

    public final void onError(Throwable t) {
        this.onTerminal(t, (cause, sub) -> sub.onError(cause), TerminalNotification::error);
    }

    public final void onComplete() {
        this.onTerminal(null, (cause, sub) -> sub.onComplete(), cause -> TerminalNotification.complete());
    }

    private void updateRequestN() {
        long actualSourceRequestN = ConcurrentUtils.calculateSourceRequested(requestedUpdater, sourceRequestedUpdater, sourceEmittedUpdater, (int)this.outstandingDemandLimit(), (Object)this);
        if (actualSourceRequestN > 0L) {
            this.requestUpstream(actualSourceRequestN);
        }
    }

    private Queue<Object> getOrCreateSignalQueue(int size) {
        if (this.signalQueue == null) {
            this.signalQueue = PlatformDependent.newUnboundedSpscQueue((int)size);
        }
        return this.signalQueue;
    }

    private void onTerminal(@Nullable Throwable t, BiConsumer<Throwable, PublisherSource.Subscriber<? super T>> emitter, Function<Throwable, TerminalNotification> terminalFunc) {
        PublisherSource.Subscriber<T> subscriber = this.subscriber();
        if (subscriber == null) {
            this.getOrCreateSignalQueue(1).add(terminalFunc.apply(t));
            this.drainSignalQueueSupplier(null, this::subscriber);
        } else if (this.hasSignalsQueued()) {
            this.getOrCreateSignalQueue(1).add(terminalFunc.apply(t));
            this.drainSignalQueue(subscriber);
        } else if (ConcurrentUtils.tryAcquireLock(emittingLockUpdater, (Object)this)) {
            emitter.accept(t, subscriber);
        } else {
            this.getOrCreateSignalQueue(1).add(terminalFunc.apply(t));
            this.drainSignalQueue(subscriber);
        }
    }

    private boolean hasSignalsQueued() {
        return this.signalQueue != null && !this.signalQueue.isEmpty();
    }

    private void drainSignalQueue(PublisherSource.Subscriber<? super T> subscriber) {
        this.drainSignalQueueSupplier(subscriber, () -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainSignalQueueSupplier(@Nullable PublisherSource.Subscriber<? super T> subscriber, Supplier<PublisherSource.Subscriber<? super T>> subFunc) {
        Throwable delayedCause = null;
        boolean tryAcquire = true;
        boolean acquired = false;
        while (tryAcquire && ConcurrentUtils.tryAcquireLock(emittingLockUpdater, (Object)this)) {
            block11: {
                try {
                    Object signal;
                    acquired = true;
                    if (subscriber == null) {
                        subscriber = subFunc.get();
                    }
                    if (subscriber == null || this.signalQueue == null || this.signalQueue.isEmpty()) break block11;
                    long innerOnNextCount = 0L;
                    long outstandingDemand = this.requested - this.sourceEmitted;
                    while (innerOnNextCount < outstandingDemand && (signal = this.signalQueue.poll()) != null) {
                        try {
                            if (signal instanceof TerminalNotification) {
                                ((TerminalNotification)signal).terminate(subscriber);
                                continue;
                            }
                            ++innerOnNextCount;
                            subscriber.onNext(SubscriberApiUtils.unwrapNullUnchecked(signal));
                        }
                        catch (Throwable cause) {
                            delayedCause = ThrowableUtils.catchUnexpected(delayedCause, (Throwable)cause);
                        }
                    }
                    if (innerOnNextCount != 0L) {
                        sourceEmittedUpdater.addAndGet(this, innerOnNextCount);
                    }
                    if (innerOnNextCount != outstandingDemand || !((signal = this.signalQueue.peek()) instanceof TerminalNotification)) break block11;
                    this.signalQueue.poll();
                    ((TerminalNotification)signal).terminate(subscriber);
                }
                catch (Throwable throwable) {
                    tryAcquire = !ConcurrentUtils.releaseLock(emittingLockUpdater, (Object)this);
                    throw throwable;
                }
            }
            tryAcquire = !ConcurrentUtils.releaseLock(emittingLockUpdater, (Object)this);
        }
        if (acquired) {
            this.updateRequestN();
        }
        if (delayedCause != null) {
            PlatformDependent.throwException(delayedCause);
        }
    }
}

