/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.UriUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class FormUrlEncodedHttpDeserializer
implements HttpDeserializer<Map<String, List<String>>> {
    static final FormUrlEncodedHttpDeserializer UTF8 = new FormUrlEncodedHttpDeserializer(StandardCharsets.UTF_8, headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, StandardCharsets.UTF_8));
    private final Charset charset;
    private final Predicate<HttpHeaders> checkContentType;

    FormUrlEncodedHttpDeserializer(Charset charset, Predicate<HttpHeaders> checkContentType) {
        this.charset = charset;
        this.checkContentType = checkContentType;
    }

    @Override
    public Map<String, List<String>> deserialize(HttpHeaders headers, Buffer payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return this.deserialize(payload);
    }

    @Override
    public BlockingIterable<Map<String, List<String>>> deserialize(HttpHeaders headers, BlockingIterable<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return () -> {
            final BlockingIterator iterator = payload.iterator();
            return new BlockingIterator<Map<String, List<String>>>(){

                public boolean hasNext(long timeout, TimeUnit unit) throws TimeoutException {
                    return iterator.hasNext(timeout, unit);
                }

                public Map<String, List<String>> next(long timeout, TimeUnit unit) throws TimeoutException {
                    return FormUrlEncodedHttpDeserializer.this.deserialize((Buffer)iterator.next(timeout, unit));
                }

                public void close() throws Exception {
                    iterator.close();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Map<String, List<String>> next() {
                    return FormUrlEncodedHttpDeserializer.this.deserialize((Buffer)iterator.next());
                }
            };
        };
    }

    @Override
    public Publisher<Map<String, List<String>>> deserialize(HttpHeaders headers, Publisher<Buffer> payload) {
        HeaderUtils.checkContentType(headers, this.checkContentType);
        return payload.map(this::deserialize);
    }

    private Map<String, List<String>> deserialize(@Nullable Buffer buffer) {
        if (buffer == null || buffer.readableBytes() == 0) {
            return Collections.emptyMap();
        }
        return UriUtils.decodeQueryParams(buffer.toString(this.charset), this.charset, 1024, (value, charset) -> {
            try {
                return URLDecoder.decode(value, charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("URLDecoder failed to find Charset: " + charset, e);
            }
        });
    }
}

