/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.EventLoopGroup;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.transport.api.DefaultExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.EventLoopAwareNettyIoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalExecutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExecutionContext.class);

    private GlobalExecutionContext() {
    }

    public static ExecutionContext<ExecutionStrategy> globalExecutionContext() {
        return GlobalExecutionContextInitializer.INSTANCE;
    }

    private static void log(Logger logger, String name, String methodName) {
        logger.info("Closure of \"{}\" was initiated using {} method. Closing the global instance before closing all resources that use it may result in unexpected behavior.", new Object[]{name, methodName, new Throwable("Stack trace")});
    }

    private static final class GlobalIoExecutor
    implements EventLoopAwareNettyIoExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIoExecutor.class);
        static final String NAME_PREFIX = "servicetalk-global-io-executor";
        private final EventLoopAwareNettyIoExecutor delegate;

        GlobalIoExecutor(EventLoopAwareNettyIoExecutor delegate) {
            this.delegate = delegate;
        }

        public Completable closeAsync() {
            return this.delegate.closeAsync().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsync()"));
        }

        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully().beforeOnSubscribe(__ -> GlobalExecutionContext.log(GlobalIoExecutor.LOGGER, NAME_PREFIX, "closeAsyncGracefully()"));
        }

        public Completable onClose() {
            return this.delegate.onClose();
        }

        public boolean isUnixDomainSocketSupported() {
            return this.delegate.isUnixDomainSocketSupported();
        }

        public boolean isFileDescriptorSocketAddressSupported() {
            return this.delegate.isFileDescriptorSocketAddressSupported();
        }

        public boolean isIoThreadSupported() {
            return this.delegate.isIoThreadSupported();
        }

        @Override
        public boolean isCurrentThreadEventLoop() {
            return this.delegate.isCurrentThreadEventLoop();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.delegate.eventLoopGroup();
        }

        @Override
        public EventLoopAwareNettyIoExecutor next() {
            return this.delegate.next();
        }

        @Override
        @Deprecated
        public Executor asExecutor() {
            return this.delegate.asExecutor();
        }

        public Cancellable execute(Runnable task) throws RejectedExecutionException {
            return this.delegate.execute(task);
        }

        public Cancellable schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
            return this.delegate.schedule(task, delay, unit);
        }
    }

    private static final class GlobalExecutionContextInitializer {
        static final ExecutionContext<ExecutionStrategy> INSTANCE;

        private GlobalExecutionContextInitializer() {
        }

        static {
            GlobalIoExecutor ioExecutor = new GlobalIoExecutor(NettyIoExecutors.createIoExecutor("servicetalk-global-io-executor"));
            Executor executor = Executors.global();
            INSTANCE = new DefaultExecutionContext(BufferAllocators.DEFAULT_ALLOCATOR, (IoExecutor)ioExecutor, executor, ExecutionStrategy.offloadAll());
            LOGGER.debug("Initialized GlobalExecutionContext");
        }
    }
}

