/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database;

import com.google.common.io.Resources;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class PostgresUtils {
    private PostgresUtils() {
    }

    public static HikariDataSource dataSource(String host, Integer port, String database, String username, String password) {
        return PostgresUtils.dataSource(String.format("jdbc:postgresql://%s:%s/%s?&user=%s&password=%s", host, port, database, username, password));
    }

    public static HikariDataSource dataSource(String url) {
        return PostgresUtils.dataSource(url, Runtime.getRuntime().availableProcessors());
    }

    public static HikariDataSource dataSource(String url, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("PoolSize cannot be inferior to 1");
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setMaximumPoolSize(poolSize);
        return new HikariDataSource(config);
    }

    public static void executeResource(Connection connection, String resource) throws IOException, SQLException {
        URL resourceURL = Resources.getResource((String)resource);
        String queries = Resources.toString((URL)resourceURL, (Charset)StandardCharsets.UTF_8);
        try (Statement statement = connection.createStatement();){
            statement.execute(queries);
        }
    }
}

