/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.RequestConcurrencyController;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.NettyHttp2ExceptionUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReservableRequestConcurrencyControllers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReservableRequestConcurrencyControllers.class);

    private ReservableRequestConcurrencyControllers() {
    }

    static ReservableRequestConcurrencyController newController(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int initialConcurrency) {
        return new ReservableRequestConcurrencyControllerMulti(maxConcurrency, onClosing, initialConcurrency);
    }

    static final class InternalRetryingHttpClientFilter
    implements StreamingHttpClientFilterFactory {
        static final StreamingHttpClientFilterFactory INSTANCE = new InternalRetryingHttpClientFilter();

        private InternalRetryingHttpClientFilter() {
        }

        public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
            return new StreamingHttpClientFilter(client){

                protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                    return delegate.request(request).retry((count, t) -> count <= 32 && t instanceof NettyHttp2ExceptionUtils.MaxConcurrentStreamsViolatedStacklessHttp2Exception);
                }

                public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
                    return this.delegate().reserveConnection(metaData);
                }
            };
        }

        public HttpExecutionStrategy requiredOffloads() {
            return HttpExecutionStrategies.offloadNone();
        }
    }

    private static final class ReservableRequestConcurrencyControllerMulti
    extends AbstractReservableRequestConcurrencyController {
        ReservableRequestConcurrencyControllerMulti(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int initialConcurrency) {
            super(maxConcurrency, onClosing, initialConcurrency);
        }

        public RequestConcurrencyController.Result tryRequest() {
            int currentPending;
            int maxConcurrency = this.lastMaxConcurrency();
            do {
                if ((currentPending = this.pendingRequests()) < 0) {
                    return RequestConcurrencyController.Result.RejectedPermanently;
                }
                if (currentPending < maxConcurrency) continue;
                return RequestConcurrencyController.Result.RejectedTemporary;
            } while (!this.casPendingRequests(currentPending, currentPending + 1));
            return RequestConcurrencyController.Result.Accepted;
        }
    }

    private static abstract class AbstractReservableRequestConcurrencyController
    implements ReservableRequestConcurrencyController {
        private static final AtomicIntegerFieldUpdater<AbstractReservableRequestConcurrencyController> pendingRequestsUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReservableRequestConcurrencyController.class, "pendingRequests");
        private static final int STATE_QUIT = -2;
        private static final int STATE_RESERVED = -1;
        private static final int STATE_IDLE = 0;
        private volatile int pendingRequests;
        private volatile int lastMaxConcurrency;

        AbstractReservableRequestConcurrencyController(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing, int initialConcurrency) {
            this.lastMaxConcurrency = initialConcurrency;
            SourceAdapters.toSource((Completable)onClosing).subscribe(new CompletableSource.Subscriber(){

                public void onSubscribe(Cancellable cancellable) {
                }

                public void onComplete() {
                    assert (pendingRequests != -2);
                    pendingRequests = -2;
                }

                public void onError(Throwable ignored) {
                    assert (pendingRequests != -2);
                    pendingRequests = -2;
                }
            });
            SourceAdapters.toSource(maxConcurrency).subscribe((PublisherSource.Subscriber)new PublisherSource.Subscriber<ConsumableEvent<Integer>>(){
                @Nullable
                private PublisherSource.Subscription subscription;

                public void onSubscribe(PublisherSource.Subscription s) {
                    if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.subscription, (PublisherSource.Subscription)s)) {
                        this.subscription = s;
                        s.request(1L);
                    }
                }

                public void onNext(@Nullable ConsumableEvent<Integer> event) {
                    int newConcurrency;
                    assert (this.subscription != null) : "Subscription can not be null in onNext.";
                    assert (event != null) : "event can not be null in onNext.";
                    int currentConcurrency = lastMaxConcurrency;
                    if (currentConcurrency < (newConcurrency = ((Integer)event.event()).intValue())) {
                        event.eventConsumed();
                        lastMaxConcurrency = newConcurrency;
                    } else if (currentConcurrency > newConcurrency) {
                        lastMaxConcurrency = newConcurrency;
                        event.eventConsumed();
                    } else {
                        event.eventConsumed();
                    }
                    this.subscription.request(1L);
                }

                public void onError(Throwable t) {
                    LOGGER.info("Unexpected error from transportEventStream(MAX_CONCURRENCY).", t);
                }

                public void onComplete() {
                    LOGGER.debug("transportEventStream(MAX_CONCURRENCY) stream completes.");
                }
            });
        }

        public final void requestFinished() {
            pendingRequestsUpdater.decrementAndGet(this);
        }

        public final boolean tryReserve() {
            return pendingRequestsUpdater.compareAndSet(this, 0, -1);
        }

        public final Completable releaseAsync() {
            return new SubscribableCompletable(){

                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    try {
                        subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
                    }
                    catch (Throwable cause) {
                        SubscriberUtils.handleExceptionFromOnSubscribe((CompletableSource.Subscriber)subscriber, (Throwable)cause);
                        return;
                    }
                    if (pendingRequestsUpdater.compareAndSet(this, -1, 0)) {
                        subscriber.onComplete();
                    } else {
                        subscriber.onError((Throwable)new IllegalStateException("Resource " + (Object)((Object)this) + (pendingRequests == -2 ? " is closed." : " was not reserved.")));
                    }
                }
            };
        }

        final int lastMaxConcurrency() {
            return this.lastMaxConcurrency;
        }

        final int pendingRequests() {
            return this.pendingRequests;
        }

        final boolean casPendingRequests(int oldValue, int newValue) {
            return pendingRequestsUpdater.compareAndSet(this, oldValue, newValue);
        }

        public final String toString() {
            return this.getClass().getSimpleName() + "{pendingRequests=" + this.pendingRequests + ", lastMaxConcurrency=" + this.lastMaxConcurrency + '}';
        }
    }

    static final class IgnoreConsumedEvent<T>
    implements ConsumableEvent<T> {
        private final T event;

        IgnoreConsumedEvent(T event) {
            this.event = Objects.requireNonNull(event);
        }

        public T event() {
            return this.event;
        }

        public void eventConsumed() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{event=" + this.event + '}';
        }
    }
}

