/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.internal.partition;

import io.servicetalk.client.api.partition.DuplicateAttributeException;
import io.servicetalk.client.api.partition.PartitionAttributes;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import java.util.Arrays;
import java.util.function.BiConsumer;

@Deprecated
public final class DefaultPartitionAttributesBuilder
implements PartitionAttributesBuilder {
    private static final int PARENT_MASK = -2;
    private Object[] keyValueArray;
    private int nextIndex;

    public DefaultPartitionAttributesBuilder(int initialSize) {
        this.keyValueArray = new Object[initialSize << 1];
    }

    public <T> PartitionAttributesBuilder add(PartitionAttributes.Key<T> key, T value) {
        int parentKeyIndex;
        PartitionAttributes.Key parentKey;
        int cmp;
        if (this.keyValueArray.length == this.nextIndex) {
            this.keyValueArray = Arrays.copyOf(this.keyValueArray, (this.keyValueArray.length << 1) + 2);
        }
        int currentIndex = this.nextIndex;
        while (currentIndex > 0 && (cmp = (parentKey = (PartitionAttributes.Key)this.keyValueArray[parentKeyIndex = currentIndex - 2 >>> 1 & 0xFFFFFFFE]).compareTo(key)) <= 0) {
            if (cmp == 0) {
                throw new DuplicateAttributeException(key, "duplicate key [" + key + "] with values: [" + value + ", " + this.keyValueArray[parentKeyIndex + 1] + "]");
            }
            this.keyValueArray[currentIndex] = parentKey;
            this.keyValueArray[currentIndex + 1] = this.keyValueArray[parentKeyIndex + 1];
            currentIndex = parentKeyIndex;
        }
        this.keyValueArray[currentIndex] = key;
        this.keyValueArray[currentIndex + 1] = value;
        this.nextIndex += 2;
        return this;
    }

    public PartitionAttributes build() {
        return new SortedArrayPartitionAttributes(this.nextIndex == this.keyValueArray.length ? this.keyValueArray : Arrays.copyOf(this.keyValueArray, this.nextIndex));
    }

    private static void heapSort(Object[] keyValueArray) {
        int originalEndKeyIndex;
        int endKeyIndex = originalEndKeyIndex = keyValueArray.length - 2;
        while (endKeyIndex > 0) {
            PartitionAttributes.Key duplicateCheckKey;
            PartitionAttributes.Key bubbleKey = (PartitionAttributes.Key)keyValueArray[endKeyIndex];
            Object bubbleValue = keyValueArray[endKeyIndex + 1];
            keyValueArray[endKeyIndex] = keyValueArray[0];
            keyValueArray[endKeyIndex + 1] = keyValueArray[1];
            keyValueArray[0] = bubbleKey;
            keyValueArray[1] = bubbleValue;
            if (endKeyIndex <= originalEndKeyIndex - 2 && (duplicateCheckKey = (PartitionAttributes.Key)keyValueArray[endKeyIndex]).equals(keyValueArray[endKeyIndex + 2])) {
                throw new DuplicateAttributeException(duplicateCheckKey, "duplicate key [" + duplicateCheckKey + "] with values: [" + keyValueArray[endKeyIndex] + ", " + keyValueArray[endKeyIndex + 3] + "]");
            }
            int halfEnd = endKeyIndex >>> 1 & 0xFFFFFFFE;
            endKeyIndex -= 2;
            int keyIndex = 0;
            while (keyIndex < halfEnd) {
                PartitionAttributes.Key rightChildKey;
                int childKeyIndex = (keyIndex << 1) + 2;
                PartitionAttributes.Key childKey = (PartitionAttributes.Key)keyValueArray[childKeyIndex];
                int rightChildKeyIndex = (keyIndex << 1) + 4;
                if (rightChildKeyIndex <= endKeyIndex && childKey.compareTo(rightChildKey = (PartitionAttributes.Key)keyValueArray[rightChildKeyIndex]) < 0) {
                    childKey = rightChildKey;
                    childKeyIndex = rightChildKeyIndex;
                }
                if (childKey.compareTo(bubbleKey) <= 0) break;
                keyValueArray[keyIndex] = childKey;
                keyValueArray[keyIndex + 1] = keyValueArray[childKeyIndex + 1];
                keyIndex = childKeyIndex;
            }
            keyValueArray[keyIndex] = bubbleKey;
            keyValueArray[keyIndex + 1] = bubbleValue;
        }
    }

    private static final class SortedArrayPartitionAttributes
    implements PartitionAttributes,
    Comparable<SortedArrayPartitionAttributes> {
        private final Object[] keyValueArray;
        private final int hashCode;

        SortedArrayPartitionAttributes(Object[] keyValueArray) {
            DefaultPartitionAttributesBuilder.heapSort(keyValueArray);
            this.keyValueArray = keyValueArray;
            int hashCode = 1;
            for (int i = 0; i < keyValueArray.length; i += 2) {
                hashCode = 31 * (31 * hashCode + keyValueArray[i].hashCode()) + keyValueArray[i + 1].hashCode();
            }
            this.hashCode = hashCode;
        }

        public <T> T get(PartitionAttributes.Key<T> key) {
            int highKeyIndex = this.keyValueArray.length - 2;
            int lowKeyIndex = 0;
            while (lowKeyIndex <= highKeyIndex) {
                int midKeyIndex = lowKeyIndex + (highKeyIndex - lowKeyIndex >>> 1 & 0xFFFFFFFE);
                int cmp = key.compareTo((PartitionAttributes.Key)this.keyValueArray[midKeyIndex]);
                if (cmp > 0) {
                    lowKeyIndex = midKeyIndex + 2;
                    continue;
                }
                if (cmp < 0) {
                    highKeyIndex = midKeyIndex - 2;
                    continue;
                }
                return (T)this.keyValueArray[midKeyIndex + 1];
            }
            return null;
        }

        public void forEach(BiConsumer<PartitionAttributes.Key, Object> action) {
            for (int i = 0; i < this.keyValueArray.length; i += 2) {
                action.accept((PartitionAttributes.Key)this.keyValueArray[i], this.keyValueArray[i + 1]);
            }
        }

        public int size() {
            return this.keyValueArray.length >>> 1;
        }

        public boolean isEmpty() {
            return this.keyValueArray.length == 0;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return o instanceof SortedArrayPartitionAttributes && Arrays.equals(this.keyValueArray, ((SortedArrayPartitionAttributes)o).keyValueArray);
        }

        public String toString() {
            if (this.keyValueArray.length < 2) {
                return "";
            }
            StringBuilder sb = new StringBuilder(256);
            sb.append('<').append(this.keyValueArray[0]).append(", ").append(this.keyValueArray[1]).append('>');
            for (int i = 2; i < this.keyValueArray.length; i += 2) {
                sb.append(" <").append(this.keyValueArray[i]).append(", ").append(this.keyValueArray[i + 1]).append('>');
            }
            return sb.toString();
        }

        @Override
        public int compareTo(SortedArrayPartitionAttributes rhs) {
            int cmp = Integer.compare(this.size(), rhs.size());
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.keyValueArray.length; i += 2) {
                PartitionAttributes.Key key = (PartitionAttributes.Key)this.keyValueArray[i];
                PartitionAttributes.Key rhsKey = (PartitionAttributes.Key)rhs.keyValueArray[i];
                cmp = key.compareTo(rhsKey);
                if (cmp == 0 && (cmp = ((PartitionAttributes.Key)this.keyValueArray[i + 1]).compareTo((PartitionAttributes.Key)rhs.keyValueArray[i + 1])) == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

