/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.GeospatialData;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileMatrixLimits;
import org.apache.baremaps.ogcapi.model.TileSetBoundingBox;
import org.apache.baremaps.ogcapi.model.TileSetCenterPoint;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import org.apache.baremaps.ogcapi.model.TileSetDataType;
import org.apache.baremaps.ogcapi.model.TileSetStyle;

@ApiModel(description="A resource describing a tileSet based on the OGC TileSet Metadata Standard. At least one of the 'TileMatrixSet',  or a link with 'rel' http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme")
@JsonTypeName(value="tileSet")
public class TileSet {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private TileSetDataType dataType;
    @Valid
    private TileSetCrs crs;
    @Valid
    private URI tileMatrixSetURI;
    @Valid
    private List<Link> links = new ArrayList<Link>();
    @Valid
    private List<TileMatrixLimits> tileMatrixSetLimits = null;
    @Valid
    private BigDecimal epoch;
    @Valid
    private List<GeospatialData> layers = null;
    @Valid
    private TileSetBoundingBox boundingBox;
    @Valid
    private TileSetCenterPoint centerPoint;
    @Valid
    private TileSetStyle style;
    @Valid
    private String attribution;
    @Valid
    private String license;
    @Valid
    private AccessConstraintsEnum accessConstraints = AccessConstraintsEnum.UNCLASSIFIED;
    @Valid
    private List<String> keywords = null;
    @Valid
    private String version;
    @Valid
    private Object created;
    @Valid
    private Object updated;
    @Valid
    private String pointOfContact;
    @Valid
    private List<String> mediaTypes = null;

    public TileSet title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="A title for this tileSet")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public TileSet description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Brief narrative description of this tile set")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TileSet dataType(TileSetDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dataType")
    @NotNull
    public TileSetDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(TileSetDataType dataType) {
        this.dataType = dataType;
    }

    public TileSet crs(TileSetCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="crs")
    @NotNull
    public TileSetCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TileSetCrs crs) {
        this.crs = crs;
    }

    public TileSet tileMatrixSetURI(URI tileMatrixSetURI) {
        this.tileMatrixSetURI = tileMatrixSetURI;
        return this;
    }

    @ApiModelProperty(value="Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.")
    @JsonProperty(value="tileMatrixSetURI")
    public URI getTileMatrixSetURI() {
        return this.tileMatrixSetURI;
    }

    @JsonProperty(value="tileMatrixSetURI")
    public void setTileMatrixSetURI(URI tileMatrixSetURI) {
        this.tileMatrixSetURI = tileMatrixSetURI;
    }

    public TileSet links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="Links to related resources. Possible link 'rel' values are: 'http://www.opengis.net/def/rel/ogc/1.0/dataset' for a URL pointing to the dataset, 'item' for a URL template to get a tile; 'alternate' for a URL pointing to another representation of the TileSetMetadata (e.g a TileJSON file); 'http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme' for a definition of the TileMatrixSet; 'http://www.opengis.net/def/rel/ogc/1.0/geodata' for pointing to a single collection (if the tileSet represents a single collection)")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public TileSet addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public TileSet removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public TileSet tileMatrixSetLimits(List<TileMatrixLimits> tileMatrixSetLimits) {
        this.tileMatrixSetLimits = tileMatrixSetLimits;
        return this;
    }

    @ApiModelProperty(value="Limits for the TileRow and TileCol values for each TileMatrix in the tileMatrixSet. If missing, there are no limits other that the ones imposed by the TileMatrixSet. If present the TileMatrices listed are limited and the rest not available at all")
    @JsonProperty(value="tileMatrixSetLimits")
    public List<TileMatrixLimits> getTileMatrixSetLimits() {
        return this.tileMatrixSetLimits;
    }

    @JsonProperty(value="tileMatrixSetLimits")
    public void setTileMatrixSetLimits(List<TileMatrixLimits> tileMatrixSetLimits) {
        this.tileMatrixSetLimits = tileMatrixSetLimits;
    }

    public TileSet addTileMatrixSetLimitsItem(TileMatrixLimits tileMatrixSetLimitsItem) {
        if (this.tileMatrixSetLimits == null) {
            this.tileMatrixSetLimits = new ArrayList<TileMatrixLimits>();
        }
        this.tileMatrixSetLimits.add(tileMatrixSetLimitsItem);
        return this;
    }

    public TileSet removeTileMatrixSetLimitsItem(TileMatrixLimits tileMatrixSetLimitsItem) {
        if (tileMatrixSetLimitsItem != null && this.tileMatrixSetLimits != null) {
            this.tileMatrixSetLimits.remove(tileMatrixSetLimitsItem);
        }
        return this;
    }

    public TileSet epoch(BigDecimal epoch) {
        this.epoch = epoch;
        return this;
    }

    @ApiModelProperty(value="Epoch of the Coordinate Reference System (CRS)")
    @JsonProperty(value="epoch")
    public BigDecimal getEpoch() {
        return this.epoch;
    }

    @JsonProperty(value="epoch")
    public void setEpoch(BigDecimal epoch) {
        this.epoch = epoch;
    }

    public TileSet layers(List<GeospatialData> layers) {
        this.layers = layers;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="layers")
    @Size(min=1)
    public @Size(min=1) List<GeospatialData> getLayers() {
        return this.layers;
    }

    @JsonProperty(value="layers")
    public void setLayers(List<GeospatialData> layers) {
        this.layers = layers;
    }

    public TileSet addLayersItem(GeospatialData layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<GeospatialData>();
        }
        this.layers.add(layersItem);
        return this;
    }

    public TileSet removeLayersItem(GeospatialData layersItem) {
        if (layersItem != null && this.layers != null) {
            this.layers.remove(layersItem);
        }
        return this;
    }

    public TileSet boundingBox(TileSetBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="boundingBox")
    public TileSetBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @JsonProperty(value="boundingBox")
    public void setBoundingBox(TileSetBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public TileSet centerPoint(TileSetCenterPoint centerPoint) {
        this.centerPoint = centerPoint;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="centerPoint")
    public TileSetCenterPoint getCenterPoint() {
        return this.centerPoint;
    }

    @JsonProperty(value="centerPoint")
    public void setCenterPoint(TileSetCenterPoint centerPoint) {
        this.centerPoint = centerPoint;
    }

    public TileSet style(TileSetStyle style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="style")
    public TileSetStyle getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    public void setStyle(TileSetStyle style) {
        this.style = style;
    }

    public TileSet attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @ApiModelProperty(value="Short reference to recognize the author or provider")
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    @JsonProperty(value="attribution")
    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public TileSet license(String license) {
        this.license = license;
        return this;
    }

    @ApiModelProperty(value="License applicable to the tiles")
    @JsonProperty(value="license")
    public String getLicense() {
        return this.license;
    }

    @JsonProperty(value="license")
    public void setLicense(String license) {
        this.license = license;
    }

    public TileSet accessConstraints(AccessConstraintsEnum accessConstraints) {
        this.accessConstraints = accessConstraints;
        return this;
    }

    @ApiModelProperty(value="Restrictions on the availability of the Tile Set that the user needs to be aware of before using or redistributing the Tile Set")
    @JsonProperty(value="accessConstraints")
    public AccessConstraintsEnum getAccessConstraints() {
        return this.accessConstraints;
    }

    @JsonProperty(value="accessConstraints")
    public void setAccessConstraints(AccessConstraintsEnum accessConstraints) {
        this.accessConstraints = accessConstraints;
    }

    public TileSet keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="keywords about this tileSet")
    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public TileSet addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public TileSet removeKeywordsItem(String keywordsItem) {
        if (keywordsItem != null && this.keywords != null) {
            this.keywords.remove(keywordsItem);
        }
        return this;
    }

    public TileSet version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Version of the Tile Set. Changes if the data behind the tiles has been changed")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public TileSet created(Object created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    public Object getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(Object created) {
        this.created = created;
    }

    public TileSet updated(Object updated) {
        this.updated = updated;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="updated")
    public Object getUpdated() {
        return this.updated;
    }

    @JsonProperty(value="updated")
    public void setUpdated(Object updated) {
        this.updated = updated;
    }

    public TileSet pointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
        return this;
    }

    @ApiModelProperty(value="Useful information to contact the authors or custodians for the Tile Set")
    @JsonProperty(value="pointOfContact")
    public String getPointOfContact() {
        return this.pointOfContact;
    }

    @JsonProperty(value="pointOfContact")
    public void setPointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
    }

    public TileSet mediaTypes(List<String> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(value="Media types available for the tiles")
    @JsonProperty(value="mediaTypes")
    public List<String> getMediaTypes() {
        return this.mediaTypes;
    }

    @JsonProperty(value="mediaTypes")
    public void setMediaTypes(List<String> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public TileSet addMediaTypesItem(String mediaTypesItem) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new ArrayList<String>();
        }
        this.mediaTypes.add(mediaTypesItem);
        return this;
    }

    public TileSet removeMediaTypesItem(String mediaTypesItem) {
        if (mediaTypesItem != null && this.mediaTypes != null) {
            this.mediaTypes.remove(mediaTypesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileSet tileSet = (TileSet)o;
        return Objects.equals(this.title, tileSet.title) && Objects.equals(this.description, tileSet.description) && Objects.equals(this.dataType, tileSet.dataType) && Objects.equals(this.crs, tileSet.crs) && Objects.equals(this.tileMatrixSetURI, tileSet.tileMatrixSetURI) && Objects.equals(this.links, tileSet.links) && Objects.equals(this.tileMatrixSetLimits, tileSet.tileMatrixSetLimits) && Objects.equals(this.epoch, tileSet.epoch) && Objects.equals(this.layers, tileSet.layers) && Objects.equals(this.boundingBox, tileSet.boundingBox) && Objects.equals(this.centerPoint, tileSet.centerPoint) && Objects.equals(this.style, tileSet.style) && Objects.equals(this.attribution, tileSet.attribution) && Objects.equals(this.license, tileSet.license) && Objects.equals((Object)this.accessConstraints, (Object)tileSet.accessConstraints) && Objects.equals(this.keywords, tileSet.keywords) && Objects.equals(this.version, tileSet.version) && Objects.equals(this.created, tileSet.created) && Objects.equals(this.updated, tileSet.updated) && Objects.equals(this.pointOfContact, tileSet.pointOfContact) && Objects.equals(this.mediaTypes, tileSet.mediaTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.description, this.dataType, this.crs, this.tileMatrixSetURI, this.links, this.tileMatrixSetLimits, this.epoch, this.layers, this.boundingBox, this.centerPoint, this.style, this.attribution, this.license, this.accessConstraints, this.keywords, this.version, this.created, this.updated, this.pointOfContact, this.mediaTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TileSet {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    tileMatrixSetURI: ").append(this.toIndentedString(this.tileMatrixSetURI)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    tileMatrixSetLimits: ").append(this.toIndentedString(this.tileMatrixSetLimits)).append("\n");
        sb.append("    epoch: ").append(this.toIndentedString(this.epoch)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    boundingBox: ").append(this.toIndentedString(this.boundingBox)).append("\n");
        sb.append("    centerPoint: ").append(this.toIndentedString(this.centerPoint)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    license: ").append(this.toIndentedString(this.license)).append("\n");
        sb.append("    accessConstraints: ").append(this.toIndentedString((Object)this.accessConstraints)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    pointOfContact: ").append(this.toIndentedString(this.pointOfContact)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessConstraintsEnum {
        UNCLASSIFIED(String.valueOf("unclassified")),
        RESTRICTED(String.valueOf("restricted")),
        CONFIDENTIAL(String.valueOf("confidential")),
        SECRET(String.valueOf("secret")),
        TOPSECRET(String.valueOf("topSecret"));

        private String value;

        private AccessConstraintsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccessConstraintsEnum fromString(String s) {
            for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static AccessConstraintsEnum fromValue(String value) {
            for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

