/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import java.net.SocketOption;
import java.util.Objects;

public final class ServiceTalkSocketOptions {
    public static final SocketOption<Integer> CONNECT_TIMEOUT = new ServiceTalkSocketOption<Integer>("CONNECT_TIMEOUT", Integer.class);
    public static final SocketOption<Integer> WRITE_BUFFER_THRESHOLD = new ServiceTalkSocketOption<Integer>("WRITE_BUFFER_THRESHOLD", Integer.class);
    public static final SocketOption<Long> IDLE_TIMEOUT = new ServiceTalkSocketOption<Long>("IDLE_TIMEOUT", Long.class);
    public static final SocketOption<Boolean> TCP_FASTOPEN_CONNECT = new ServiceTalkSocketOption<Boolean>("TCP_FASTOPEN_CONNECT", Boolean.class);
    public static final SocketOption<Integer> SO_BACKLOG = new ServiceTalkSocketOption<Integer>("SO_BACKLOG", Integer.class);
    public static final SocketOption<Integer> TCP_FASTOPEN_BACKLOG = new ServiceTalkSocketOption<Integer>("TCP_FASTOPEN_BACKLOG", Integer.class);

    private ServiceTalkSocketOptions() {
    }

    private static final class ServiceTalkSocketOption<T>
    implements SocketOption<T> {
        private final String name;
        private final Class<T> type;

        ServiceTalkSocketOption(String name, Class<T> type) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceTalkSocketOption that = (ServiceTalkSocketOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

