/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.schema;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public interface DataColumn {
    public String name();

    public Type type();

    public static enum Type {
        BYTE(Byte.class),
        BYTE_ARRAY(byte[].class),
        BOOLEAN(Boolean.class),
        BOOLEAN_ARRAY(boolean[].class),
        SHORT(Short.class),
        SHORT_ARRAY(short[].class),
        INTEGER(Integer.class),
        INTEGER_ARRAY(int[].class),
        LONG(Long.class),
        LONG_ARRAY(long[].class),
        FLOAT(Float.class),
        FLOAT_ARRAY(float[].class),
        DOUBLE(Double.class),
        DOUBLE_ARRAY(double[].class),
        STRING(String.class),
        COORDINATE(Coordinate.class),
        GEOMETRY(Geometry.class),
        POINT(Point.class),
        LINESTRING(LineString.class),
        POLYGON(Polygon.class),
        MULTIPOINT(MultiPoint.class),
        MULTILINESTRING(MultiLineString.class),
        MULTIPOLYGON(MultiPolygon.class),
        GEOMETRYCOLLECTION(GeometryCollection.class),
        INET_ADDRESS(InetAddress.class),
        INET4_ADDRESS(Inet4Address.class),
        INET6_ADDRESS(Inet6Address.class),
        LOCAL_DATE(LocalDate.class),
        LOCAL_TIME(LocalTime.class),
        LOCAL_DATE_TIME(LocalDateTime.class);

        private final Class<?> binding;

        private Type(Class<?> binding) {
            this.binding = binding;
        }

        public Class<?> binding() {
            return this.binding;
        }

        public static Type fromBinding(Class<?> binding) {
            for (Type type : Type.values()) {
                if (!type.binding().equals(binding)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unsupported binding: " + binding);
        }
    }
}

