/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.stream;

import java.util.ArrayList;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

class BatchedSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> spliterator;
    private final int batchSize;

    public BatchedSpliterator(Spliterator<T> spliterator, int batchSize) {
        this.spliterator = spliterator;
        this.batchSize = batchSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.spliterator.tryAdvance(action);
    }

    @Override
    public Spliterator<T> trySplit() {
        ArrayList batch = new ArrayList();
        while (batch.size() < this.batchSize) {
            if (this.tryAdvance(batch::add)) continue;
        }
        if (!batch.isEmpty()) {
            return Spliterators.spliterator(batch, this.characteristics());
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics() | 0x40 | 0x4000;
    }
}

