/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.postgres;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;

public class PostgresQuery {
    private final String layer;
    private final Integer minzoom;
    private final Integer maxzoom;
    private final String sql;
    private final PlainSelect ast;

    public PostgresQuery(String layer, Integer minzoom, Integer maxzoom, String sql) {
        this.layer = layer;
        this.minzoom = minzoom;
        this.maxzoom = maxzoom;
        this.sql = sql;
        this.ast = this.parse(sql);
    }

    public String getLayer() {
        return this.layer;
    }

    public Integer getMinzoom() {
        return this.minzoom;
    }

    public Integer getMaxzoom() {
        return this.maxzoom;
    }

    public String getSql() {
        return this.sql;
    }

    public PlainSelect getAst() {
        return this.ast;
    }

    private PlainSelect parse(String query) {
        PlainSelect plainSelect;
        try {
            Select select = (Select)CCJSqlParserUtil.parse((String)query);
            plainSelect = (PlainSelect)select.getSelectBody();
        }
        catch (JSQLParserException e) {
            String message = String.format("The query is malformed.\n\tQuery:\n\t\t%s", query);
            throw new IllegalArgumentException(message, e);
        }
        if (plainSelect.getSelectItems().size() != 3) {
            String message = String.format("The query is malformed.\n\tExpected format:\n\t\tSELECT c1::bigint, c2::jsonb, c3::geometry FROM t WHERE c\n\tActual query:\n\t\t%s", query);
            throw new IllegalArgumentException(message);
        }
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)new SelectItemVisitorAdapter(){

                public void visit(SelectExpressionItem selectExpressionItem) {
                    selectExpressionItem.setAlias(null);
                }
            });
        }
        return plainSelect;
    }
}

