/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.db.table.TableConstraints;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.extension.schema.columns.DataColumnsDao;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public abstract class UserTableReader<TColumn extends UserColumn, TTable extends UserTable<TColumn>> {
    private static final Logger log = Logger.getLogger(UserTableReader.class.getName());
    private final String tableName;

    protected UserTableReader(String tableName) {
        this.tableName = tableName;
    }

    protected abstract TTable createTable(String var1, List<TColumn> var2);

    protected abstract TColumn createColumn(TableColumn var1);

    public TTable readTable(GeoPackageCoreConnection db) {
        ArrayList<TColumn> columnList = new ArrayList<TColumn>();
        TableInfo tableInfo = TableInfo.info(db, this.tableName);
        if (tableInfo == null) {
            throw new GeoPackageException("Table does not exist: " + this.tableName);
        }
        TableConstraints constraints = SQLiteMaster.queryForConstraints(db, this.tableName);
        DataColumnsDao dataColumnsDao = DataColumnsDao.create(db);
        for (TableColumn tableColumn : tableInfo.getColumns()) {
            if (tableColumn.getDataType() == null) {
                log.log(Level.SEVERE, "Unexpected column data type: '" + tableColumn.getType() + "', column: " + tableColumn.getName());
            }
            TColumn column = this.createColumn(tableColumn);
            ((UserColumn)column).setAutoincrement(false);
            ColumnConstraints columnConstraints = constraints.getColumnConstraints(((UserColumn)column).getName());
            if (columnConstraints != null && columnConstraints.hasConstraints()) {
                ((UserColumn)column).clearConstraints(false);
                ((UserColumn)column).addConstraints(columnConstraints);
            }
            try {
                dataColumnsDao.loadSchema(this.tableName, (UserColumn)column);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to load column schema. table: " + this.tableName + ", column: " + ((UserColumn)column).getName(), e);
            }
            columnList.add(column);
        }
        TTable table = this.createTable(this.tableName, columnList);
        ((UserTable)table).addConstraints(constraints.getTableConstraints());
        return table;
    }
}

