/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultResponseEntity;
import com.linecorp.armeria.common.HttpEntity;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import java.util.Objects;

@UnstableApi
public interface ResponseEntity<T>
extends HttpEntity<T> {
    public static ResponseEntity<Void> of(ResponseHeaders headers) {
        return ResponseEntity.of(headers, null, HttpHeaders.of());
    }

    public static <T> ResponseEntity<T> of(ResponseHeaders headers, T content) {
        Objects.requireNonNull(content, "content");
        return ResponseEntity.of(headers, content, HttpHeaders.of());
    }

    public static <T> ResponseEntity<T> of(T content) {
        Objects.requireNonNull(content, "content");
        return ResponseEntity.of(ResponseHeaders.of(HttpStatus.OK), content, HttpHeaders.of());
    }

    public static <T> ResponseEntity<T> of(ResponseHeaders headers, @Nullable T content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        return new DefaultResponseEntity<T>(headers, content, trailers);
    }

    @Override
    public ResponseHeaders headers();

    default public HttpStatus status() {
        return this.headers().status();
    }
}

