/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;

public final class HeaderOverridingHttpRequest
implements HttpRequest {
    private final HttpRequest delegate;
    private final RequestHeaders headers;

    public static HeaderOverridingHttpRequest of(HttpRequest delegate, RequestHeaders headers) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(headers, "headers");
        if (delegate instanceof HeaderOverridingHttpRequest) {
            return new HeaderOverridingHttpRequest(((HeaderOverridingHttpRequest)delegate).delegate(), headers);
        }
        return new HeaderOverridingHttpRequest(delegate, headers);
    }

    HeaderOverridingHttpRequest(HttpRequest delegate, RequestHeaders headers) {
        this.delegate = delegate;
        this.headers = headers;
    }

    public HttpRequest delegate() {
        return this.delegate;
    }

    @Override
    public HttpRequest withHeaders(RequestHeaders newHeaders) {
        Objects.requireNonNull(newHeaders, "newHeaders");
        if (this.headers == newHeaders) {
            return this;
        }
        if (this.delegate.headers() == newHeaders) {
            return this.delegate;
        }
        return this.delegate.withHeaders(newHeaders);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public long demand() {
        return this.delegate.demand();
    }

    @Override
    public boolean isComplete() {
        return this.delegate.isComplete();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public CompletableFuture<List<HttpObject>> collect(EventExecutor executor, SubscriptionOption ... options) {
        return this.delegate.collect(executor, options);
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        this.delegate.subscribe(subscriber, executor, options);
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        return this.delegate.defaultSubscriberExecutor();
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    @Override
    public void abort(Throwable cause) {
        this.delegate.abort(Objects.requireNonNull(cause, "cause"));
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public URI uri() {
        return this.headers.uri();
    }

    @Override
    @Nullable
    public String scheme() {
        return this.headers.scheme();
    }

    @Override
    public HttpMethod method() {
        return this.headers.method();
    }

    @Override
    public String path() {
        return this.headers.path();
    }

    @Override
    @Nullable
    public String authority() {
        return this.headers.authority();
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.headers.contentType();
    }

    @Override
    public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions options) {
        return this.delegate.aggregate(options).thenApply(this::replaceHeaders);
    }

    private AggregatedHttpRequest replaceHeaders(AggregatedHttpRequest req) {
        return AggregatedHttpRequest.of(this.headers, req.content(), req.trailers());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.headers()).toString();
    }
}

