/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.temporal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.DateTime;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.wkt.CRSWriter;

public class TemporalDatum
implements Identifiable {
    private static final Logger logger = Logger.getLogger(TemporalDatum.class.getName());
    private String name = null;
    private String calendar = null;
    private String origin = null;
    private DateTime originDateTime = null;
    private List<Identifier> identifiers = null;

    public TemporalDatum() {
    }

    public TemporalDatum(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCalendar() {
        return this.calendar;
    }

    public boolean hasCalendar() {
        return this.getCalendar() != null;
    }

    public void setCalendar(String calendar) {
        this.calendar = calendar;
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean hasOrigin() {
        return this.getOrigin() != null;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        DateTime dateTime = DateTime.tryParse(origin);
        if (dateTime != null) {
            this.originDateTime = dateTime;
        }
    }

    public DateTime getOriginDateTime() {
        return this.originDateTime;
    }

    public boolean hasOriginDateTime() {
        return this.getOriginDateTime() != null;
    }

    public void setOriginDateTime(DateTime originDateTime) {
        this.originDateTime = originDateTime;
        this.origin = originDateTime.toString();
    }

    public void setOriginDateTime(String origin) {
        this.origin = origin;
        this.originDateTime = DateTime.parse(origin);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.originDateTime == null ? 0 : this.originDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalDatum other = (TemporalDatum)obj;
        if (this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar)) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        return !(this.originDateTime == null ? other.originDateTime != null : !this.originDateTime.equals(other.originDateTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

