/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;

public class ShortArrayDataType
implements DataType<short[]> {
    @Override
    public int size(short[] values) {
        return 4 + values.length * 2;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, short[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (short value : values) {
            buffer.putShort(p, value);
            p += 2;
        }
    }

    @Override
    public short[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 2;
        short[] values = new short[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.getShort(position + 4 + index * 2);
        }
        return values;
    }
}

