/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.Strings;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Identification;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class DataStore
implements Resource,
Localized,
AutoCloseable {
    protected final DataStoreProvider provider;
    private final String name;
    private Locale locale;
    protected final StoreListeners listeners;

    protected DataStore() {
        this.provider = null;
        this.name = null;
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(null, this);
    }

    protected DataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"connector", (Object)connector);
        this.provider = provider;
        this.name = connector.getStorageName();
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.listeners = new StoreListeners(connector.getOption(DataOptionKey.PARENT_LISTENERS), this);
    }

    protected DataStore(DataStore parent, DataStoreProvider provider, StorageConnector connector, boolean hidden) throws DataStoreException {
        StoreListeners forwardTo;
        ArgumentChecks.ensureNonNull((String)"connector", (Object)connector);
        this.provider = provider;
        this.name = connector.getStorageName();
        if (parent != null) {
            this.locale = parent.locale;
            if (hidden) {
                this.listeners = parent.listeners;
                return;
            }
            forwardTo = parent.listeners;
        } else {
            this.locale = Locale.getDefault(Locale.Category.DISPLAY);
            forwardTo = null;
        }
        this.listeners = new StoreListeners(forwardTo, this);
    }

    public DataStoreProvider getProvider() {
        return this.provider;
    }

    public abstract Optional<ParameterValueGroup> getOpenParameters();

    public synchronized void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        this.locale = locale;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public String getDisplayName() {
        return this.name;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            Citation citation = null;
            for (Identification id : metadata.getIdentificationInfo()) {
                Citation c = id.getCitation();
                if (c == null) continue;
                if (citation != null && citation != c) {
                    return Optional.empty();
                }
                citation = c;
            }
            if (citation != null) {
                ReferenceIdentifier first = null;
                for (Citation c : citation.getIdentifiers()) {
                    if (c instanceof GenericName) {
                        return Optional.of((GenericName)c);
                    }
                    if (first != null || !(c instanceof ReferenceIdentifier)) continue;
                    first = (ReferenceIdentifier)c;
                }
                if (first != null) {
                    return Optional.of(new NamedIdentifier(first));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public abstract Metadata getMetadata() throws DataStoreException;

    public Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        return Optional.empty();
    }

    public Resource findResource(String identifier) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)identifier);
        Resource resource = this.findResource(identifier, this, new IdentityHashMap<Resource, Boolean>());
        if (resource != null) {
            return resource;
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound(this, identifier));
    }

    private Resource findResource(String identifier, Resource candidate, Map<Resource, Boolean> visited) throws DataStoreException {
        if (candidate != null && visited.put(candidate, Boolean.TRUE) == null) {
            GenericName name = candidate.getIdentifier().orElse(null);
            if (name != null) {
                do {
                    if (!identifier.equals(name.toString())) continue;
                    return candidate;
                } while (name instanceof ScopedName && name != (name = ((ScopedName)name).tail()));
            }
            if (candidate instanceof Aggregate) {
                Resource result = null;
                for (Resource resource : ((Aggregate)candidate).components()) {
                    Resource match = this.findResource(identifier, resource, visited);
                    if (match == null) continue;
                    if (result == null) {
                        result = match;
                        continue;
                    }
                    throw new IllegalNameException(Resources.forLocale(this.getLocale()).getString((short)23, this.getDisplayName(), identifier));
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.listeners.addListener(eventType, listener);
    }

    @Override
    public <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        this.listeners.removeListener(eventType, listener);
    }

    @Override
    public abstract void close() throws DataStoreException;

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.getDisplayName());
    }
}

