/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.baremaps.shapefile.DBaseFieldDescriptor;
import org.apache.baremaps.shapefile.DbaseByteReader;
import org.apache.baremaps.shapefile.ShapefileByteReader;
import org.apache.baremaps.shapefile.ShapefileDescriptor;
import org.apache.baremaps.shapefile.ShapefileException;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;

public class ShapefileInputStream
extends InputStream {
    private DbaseByteReader dbaseReader;
    private File shapefile;
    private File databaseFile;
    private File shapefileIndex;
    private boolean hasShapefileIndex;
    private DataSchema schema;
    private ShapefileByteReader shapefileReader;

    public ShapefileInputStream(File shapefile, File dbaseFile, File shpfileIndex) throws IOException {
        this.shapefile = shapefile;
        this.databaseFile = dbaseFile;
        this.dbaseReader = new DbaseByteReader(dbaseFile, null);
        if (shpfileIndex != null && shpfileIndex.exists() && shpfileIndex.isFile()) {
            this.shapefileIndex = shpfileIndex;
            this.hasShapefileIndex = true;
        } else {
            this.hasShapefileIndex = false;
        }
        this.shapefileReader = new ShapefileByteReader(this.shapefile, this.databaseFile, this.shapefileIndex);
        this.schema = this.shapefileReader.getSchema();
    }

    public ShapefileInputStream(File shpfile, File dbaseFile) throws IOException {
        this(shpfile, dbaseFile, null);
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("InputFeatureStream doesn't allow the use of read(). Use readFeature() instead.");
    }

    @Override
    public int available() {
        throw new UnsupportedOperationException("InputFeatureStream doesn't allow the use of available(). Use readFeature() will return null when feature are no more available.");
    }

    @Override
    public void close() throws IOException {
        if (this.dbaseReader != null) {
            this.dbaseReader.close();
        }
        if (this.shapefileReader != null) {
            this.shapefileReader.close();
        }
    }

    public DataRow readRow() throws ShapefileException {
        if (!this.dbaseReader.nextRowAvailable()) {
            return null;
        }
        DataRow row = this.schema.createRow();
        this.dbaseReader.loadRow(row);
        this.shapefileReader.setRowNum(this.dbaseReader.getRowNum());
        this.shapefileReader.completeRow(row);
        return row;
    }

    public DataSchema schema() {
        return this.schema;
    }

    public ShapefileDescriptor getShapefileDescriptor() {
        return this.shapefileReader.getShapefileDescriptor();
    }

    public List<DBaseFieldDescriptor> getDatabaseFieldsDescriptors() {
        return this.shapefileReader.getFieldsDescriptors();
    }

    public boolean hasShapefileIndex() {
        return this.hasShapefileIndex;
    }
}

