/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.bind.metadata.replace.QualityParameter;
import org.apache.sis.xml.bind.referencing.CC_OperationParameter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.TypeName;

@XmlType(name="OperationParameterType")
@XmlRootElement(name="OperationParameter")
public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -1978932430298071693L;
    private Class<T> valueClass;
    private final Set<T> validValues;
    private Range<?> valueDomain;
    private final T defaultValue;

    public DefaultParameterDescriptor(Map<String, ?> properties, int minimumOccurs, int maximumOccurs, Class<T> valueClass, Range<?> valueDomain, T[] validValues, T defaultValue) {
        super(properties, minimumOccurs, maximumOccurs);
        Verifier error;
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        ArgumentChecks.ensureCanCast((String)"defaultValue", valueClass, defaultValue);
        if (valueDomain != null) {
            Class<Object> componentType = valueClass.getComponentType();
            componentType = componentType != null ? Numbers.primitiveToWrapper(componentType) : valueClass;
            Class elementType = valueDomain.getElementType();
            if (elementType != componentType) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)42, (Object)"valueDomain", (Object)("Range<" + Classes.getShortName((Class)elementType) + ">")));
            }
            if (valueDomain.isEmpty()) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)60, (Object)valueDomain.getMinValue(), (Object)valueDomain.getMaxValue()));
            }
        }
        this.valueClass = valueClass;
        this.valueDomain = valueDomain;
        this.defaultValue = defaultValue;
        if (validValues != null) {
            Set valids = CollectionsExt.createSetForType(valueClass, (int)validValues.length);
            for (T value : validValues) {
                if (value == null) continue;
                Verifier error2 = Verifier.ensureValidValue(valueClass, null, valueDomain, value);
                if (error2 != null) {
                    throw new IllegalArgumentException(error2.message(properties, super.getName().getCode(), value));
                }
                valids.add(value);
            }
            this.validValues = CollectionsExt.unmodifiableOrCopy((Set)valids);
        } else {
            this.validValues = null;
        }
        if (defaultValue != null && (error = Verifier.ensureValidValue(valueClass, this.validValues, valueDomain, defaultValue)) != null) {
            throw new IllegalArgumentException(error.message(properties, super.getName().getCode(), defaultValue));
        }
    }

    protected DefaultParameterDescriptor(ParameterDescriptor<T> descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        this.valueClass = descriptor.getValueClass();
        this.validValues = descriptor.getValidValues();
        this.defaultValue = descriptor.getDefaultValue();
        this.valueDomain = Parameters.getValueDomain(descriptor);
    }

    public static <T> DefaultParameterDescriptor<T> castOrCopy(ParameterDescriptor<T> object) {
        return object == null || object instanceof DefaultParameterDescriptor ? (DefaultParameterDescriptor<T>)object : new DefaultParameterDescriptor<T>(object);
    }

    public Class<? extends ParameterDescriptor<T>> getInterface() {
        return ParameterDescriptor.class;
    }

    public TypeName getValueType() {
        return QualityParameter.getValueType(this.valueClass);
    }

    public final Class<T> getValueClass() {
        return this.valueClass;
    }

    public Set<T> getValidValues() {
        return this.validValues;
    }

    public final Range<?> getValueDomain() {
        return this.valueDomain;
    }

    public Comparable<T> getMinimumValue() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain != null && valueDomain.getElementType() == this.valueClass ? valueDomain.getMinValue() : null;
    }

    public Comparable<T> getMaximumValue() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain != null && valueDomain.getElementType() == this.valueClass ? valueDomain.getMaxValue() : null;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Unit<?> getUnit() {
        Range<?> valueDomain = this.valueDomain;
        return valueDomain instanceof MeasurementRange ? ((MeasurementRange)valueDomain).unit() : null;
    }

    public ParameterValue<T> createValue() {
        return new DefaultParameterValue(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                default: {
                    ParameterDescriptor that = (ParameterDescriptor)object;
                    return this.getValueClass() == that.getValueClass() && Objects.deepEquals(this.getDefaultValue(), that.getDefaultValue()) && Utilities.deepEquals(this.getUnit(), (Object)that.getUnit(), (ComparisonMode)mode) && (this.isHeuristicMatchForName(that.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)that, this.getName().getCode()));
                }
                case BY_CONTRACT: {
                    ParameterDescriptor that = (ParameterDescriptor)object;
                    return this.getMinimumOccurs() == that.getMinimumOccurs() && this.getMaximumOccurs() == that.getMaximumOccurs() && this.getValueClass() == that.getValueClass() && Objects.equals(this.getValidValues(), that.getValidValues()) && Objects.equals(this.getMinimumValue(), that.getMinimumValue()) && Objects.equals(this.getMaximumValue(), that.getMaximumValue()) && Objects.deepEquals(this.getDefaultValue(), that.getDefaultValue()) && Utilities.deepEquals(this.getUnit(), (Object)that.getUnit(), (ComparisonMode)mode);
                }
                case STRICT: 
            }
            DefaultParameterDescriptor that = (DefaultParameterDescriptor)object;
            return this.valueClass == that.valueClass && Objects.equals(this.validValues, that.validValues) && Objects.equals(this.valueDomain, that.valueDomain) && Objects.deepEquals(this.defaultValue, that.defaultValue);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return (long)Arrays.deepHashCode(new Object[]{this.valueClass, this.valueDomain, this.defaultValue}) + super.computeHashCode();
    }

    private DefaultParameterDescriptor() {
        PropertyType wrapper = Context.getWrapper((Context)Context.current());
        if (wrapper instanceof CC_OperationParameter) {
            CC_OperationParameter param = (CC_OperationParameter)wrapper;
            this.valueClass = param.valueClass;
            this.valueDomain = param.valueDomain;
        }
        this.validValues = null;
        this.defaultValue = null;
    }

    final void setValueClass(DefaultParameterValue<?> param) {
        this.valueClass = Classes.findCommonClass(this.valueClass, CC_OperationParameter.valueClass(param));
        if (this.valueDomain == null) {
            this.valueDomain = CC_OperationParameter.valueDomain(param);
        }
    }
}

