"""
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
"""

from abc import ABC, abstractmethod
from gravitino.dto.responses.error_response import ErrorResponse


class ErrorHandler(ABC):
    """The ErrorHandler class is an abstract class specialized for handling ErrorResponse objects.
    Subclasses of ErrorHandler must implement the parseResponse method to provide custom parsing
    logic for different types of errors.
    """

    @abstractmethod
    def handle(self, error_response: ErrorResponse):
        """Handles the error response and raise the appropriate Exception. The implementation will use the
        provided error response to determine which exception to raise.

        Args:
          error_response: the error response from the server

        Raises:
          appropriate Exception.
        """
