/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ImmutableCounterResult;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public interface CounterResult {
    public MetricsContext.Unit unit();

    public long value();

    public static CounterResult fromCounter(Counter counter) {
        Preconditions.checkArgument((null != counter ? 1 : 0) != 0, (Object)"Invalid counter: null");
        if (counter.isNoop()) {
            return null;
        }
        return ImmutableCounterResult.builder().unit(counter.unit()).value(counter.value()).build();
    }

    public static CounterResult of(MetricsContext.Unit unit, long value) {
        return ImmutableCounterResult.builder().unit(unit).value(value).build();
    }
}

