/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

public interface UserRoleRelMapper {
    public static final String USER_TABLE_NAME = "user_meta";
    public static final String USER_ROLE_RELATION_TABLE_NAME = "user_role_rel";

    @Insert(value={"<script>", "INSERT INTO user_role_rel(user_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES ", "<foreach collection='userRoleRels' item='item' separator=','>", "(#{item.userId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})", "</foreach>", "</script>"})
    public void batchInsertUserRoleRel(@Param(value="userRoleRels") List<UserRoleRelPO> var1);

    @Insert(value={"<script>", "INSERT INTO user_role_rel(user_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES ", "<foreach collection='userRoleRels' item='item' separator=','>", "(#{item.userId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})", "</foreach>", " ON DUPLICATE KEY UPDATE user_id = VALUES(user_id), role_id = VALUES(role_id), audit_info = VALUES(audit_info), current_version = VALUES(current_version), last_version = VALUES(last_version), deleted_at = VALUES(deleted_at)", "</script>"})
    public void batchInsertUserRoleRelOnDuplicateKeyUpdate(@Param(value="userRoleRels") List<UserRoleRelPO> var1);

    @Update(value={"UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND deleted_at = 0"})
    public void softDeleteUserRoleRelByUserId(@Param(value="userId") Long var1);

    @Update(value={"<script>", "UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND role_id in (", "<foreach collection='roleIds' item='roleId' separator=','>", "#{roleId}", "</foreach>", ") AND deleted_at = 0", "</script>"})
    public void softDeleteUserRoleRelByUserAndRoles(@Param(value="userId") Long var1, @Param(value="roleIds") List<Long> var2);

    @Update(value={"UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id IN (SELECT user_id FROM user_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0) AND deleted_at = 0"})
    public void softDeleteUserRoleRelByMetalakeId(Long var1);

    @Update(value={"UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0"})
    public void softDeleteUserRoleRelByRoleId(@Param(value="roleId") Long var1);

    @Delete(value={"DELETE FROM user_role_rel WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteUserRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

