/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Map;
import java.util.Properties;
import org.apache.iceberg.ClientPoolImpl;
import org.apache.iceberg.jdbc.JdbcUtil;
import org.apache.iceberg.jdbc.UncheckedSQLException;

public class JdbcClientPool
extends ClientPoolImpl<Connection, SQLException> {
    private final String dbUrl;
    private final Map<String, String> properties;

    public JdbcClientPool(String dbUrl, Map<String, String> props) {
        this(Integer.parseInt(props.getOrDefault("clients", String.valueOf(2))), dbUrl, props);
    }

    public JdbcClientPool(int poolSize, String dbUrl, Map<String, String> props) {
        super(poolSize, SQLNonTransientConnectionException.class, true);
        this.properties = props;
        this.dbUrl = dbUrl;
    }

    @Override
    protected Connection newClient() {
        try {
            Properties dbProps = JdbcUtil.filterAndRemovePrefix(this.properties, "jdbc.");
            return DriverManager.getConnection(this.dbUrl, dbProps);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to connect: %s", this.dbUrl);
        }
    }

    @Override
    protected Connection reconnect(Connection client) {
        this.close(client);
        return this.newClient();
    }

    @Override
    protected void close(Connection client) {
        try {
            client.close();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to close connection", new Object[0]);
        }
    }
}

