/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameCatalogRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateCatalogCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=SetCatalogPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveCatalogPropertyRequest.class, name="removeProperty")})
public interface CatalogUpdateRequest
extends RESTRequest {
    public CatalogChange catalogChange();

    public static class RemoveCatalogPropertyRequest
    implements CatalogUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveCatalogPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveCatalogPropertyRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        @Override
        public CatalogChange catalogChange() {
            return CatalogChange.removeProperty((String)this.property);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveCatalogPropertyRequest)) {
                return false;
            }
            RemoveCatalogPropertyRequest other = (RemoveCatalogPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveCatalogPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "CatalogUpdateRequest.RemoveCatalogPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetCatalogPropertyRequest
    implements CatalogUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetCatalogPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetCatalogPropertyRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.value), (Object)"\"value\" field is required and cannot be empty");
        }

        @Override
        public CatalogChange catalogChange() {
            return CatalogChange.setProperty((String)this.property, (String)this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetCatalogPropertyRequest)) {
                return false;
            }
            SetCatalogPropertyRequest other = (SetCatalogPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetCatalogPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "CatalogUpdateRequest.SetCatalogPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateCatalogCommentRequest
    implements CatalogUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateCatalogCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateCatalogCommentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newComment), (Object)"\"newComment\" field is required and cannot be empty");
        }

        @Override
        public CatalogChange catalogChange() {
            return CatalogChange.updateComment((String)this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateCatalogCommentRequest)) {
                return false;
            }
            UpdateCatalogCommentRequest other = (UpdateCatalogCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateCatalogCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "CatalogUpdateRequest.UpdateCatalogCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameCatalogRequest
    implements CatalogUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenameCatalogRequest() {
            this(null);
        }

        public RenameCatalogRequest(String newName) {
            this.newName = newName;
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" field is required and cannot be empty");
        }

        @Override
        public CatalogChange catalogChange() {
            return CatalogChange.rename((String)this.newName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameCatalogRequest)) {
                return false;
            }
            RenameCatalogRequest other = (RenameCatalogRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameCatalogRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "CatalogUpdateRequest.RenameCatalogRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

