/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Strategy;

@JsonSerialize(using=JsonUtils.DistributionSerializer.class)
@JsonDeserialize(using=JsonUtils.DistributionDeserializer.class)
public class DistributionDTO
implements Distribution {
    public static final DistributionDTO NONE = DistributionDTO.builder().withStrategy(Strategy.NONE).withNumber(0).withArgs(FunctionArg.EMPTY_ARGS).build();
    private final Strategy strategy;
    private final int number;
    private final FunctionArg[] args;

    public static Builder builder() {
        return new Builder();
    }

    private DistributionDTO(Strategy strategy, int number, FunctionArg[] args) {
        this.args = args;
        this.number = number;
        this.strategy = strategy;
    }

    public FunctionArg[] args() {
        return this.args;
    }

    public Strategy strategy() {
        return this.strategy;
    }

    public int number() {
        return this.number;
    }

    public Expression[] expressions() {
        return this.args;
    }

    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        Arrays.stream(this.args).forEach(expression -> expression.validate(columns));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistributionDTO)) {
            return false;
        }
        DistributionDTO that = (DistributionDTO)o;
        if (this.number != that.number) {
            return false;
        }
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        return this.strategy == that.strategy;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.args);
        result = 31 * result + this.number;
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private FunctionArg[] args;
        private int number = 0;
        private Strategy strategy;

        private Builder() {
        }

        public Builder withArgs(FunctionArg ... args) {
            this.args = args;
            return this;
        }

        public Builder withNumber(int bucketNum) {
            this.number = bucketNum;
            return this;
        }

        public Builder withStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public DistributionDTO build() {
            this.strategy = this.strategy == null ? Strategy.HASH : this.strategy;
            Preconditions.checkState((this.args != null ? 1 : 0) != 0, (Object)"expressions cannot be null");
            Preconditions.checkState((this.number >= 0 ? 1 : 0) != 0, (Object)"bucketNum must be greater than 0");
            return new DistributionDTO(this.strategy, this.number, this.args);
        }
    }
}

