/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import java.util.List;
import org.apache.gravitino.Config;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.AuthenticatorFactory;

public class ServerAuthenticator {
    private List<Authenticator> authenticators;

    private ServerAuthenticator() {
    }

    public static ServerAuthenticator getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void initialize(Config config) {
        this.authenticators = AuthenticatorFactory.createAuthenticators(config);
        for (Authenticator authenticator : this.authenticators) {
            authenticator.initialize(config);
        }
    }

    public List<Authenticator> authenticators() {
        return this.authenticators;
    }

    private static class InstanceHolder {
        private static final ServerAuthenticator INSTANCE = new ServerAuthenticator();

        private InstanceHolder() {
        }
    }
}

