/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(StringIdentifier.class);
    public static final String ID_KEY = "gravitino.identifier";
    public static final StringIdentifier DUMMY_ID = StringIdentifier.fromId(-1L);
    @VisibleForTesting
    static final int CURRENT_FORMAT_VERSION = 1;
    @VisibleForTesting
    static final String CURRENT_FORMAT = "gravitino.v%d.uid%d";
    private static final String STRING_COMMENT = "From Gravitino, DO NOT EDIT: ";
    private static final String STRING_COMMENT_FORMAT = "%s(%s%s)";
    private static final Pattern CURRENT_FORMAT_REGEX = Pattern.compile("gravitino\\.v(\\d+)\\.uid(\\d+)");
    private static final Map<Integer, Pair<String, Pattern>> SUPPORTED_FORMAT = ImmutableMap.builder().put((Object)1, (Object)Pair.of((Object)"gravitino.v%d.uid%d", (Object)CURRENT_FORMAT_REGEX)).build();
    private final long id;

    private StringIdentifier(long id) {
        this.id = id;
    }

    public static StringIdentifier fromId(long id) {
        return new StringIdentifier(id);
    }

    public static StringIdentifier fromString(String idString) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)idString), (Object)"Input id string cannot be null or empty");
        for (Map.Entry<Integer, Pair<String, Pattern>> entry : SUPPORTED_FORMAT.entrySet()) {
            int supportedVersion = entry.getKey();
            Pair<String, Pattern> format = entry.getValue();
            Pattern pattern = (Pattern)format.getRight();
            Matcher m = pattern.matcher(idString);
            if (!m.matches()) continue;
            int version = Integer.parseInt(m.group(1));
            long id = Long.parseLong(m.group(2));
            if (version != supportedVersion) continue;
            return new StringIdentifier(id);
        }
        throw new IllegalArgumentException("Invalid string identifier format: " + idString);
    }

    public long id() {
        return this.id;
    }

    public String toString() {
        return String.format(CURRENT_FORMAT, 1, this.id);
    }

    public static Map<String, String> newPropertiesWithId(StringIdentifier stringId, Map<String, String> properties) {
        if (properties == null) {
            return ImmutableMap.of((Object)ID_KEY, (Object)stringId.toString());
        }
        if (properties.containsKey(ID_KEY)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Property {}:{} already existed in the properties, this is unexpected, we will ignore adding the identifier to the properties", (Object)ID_KEY, (Object)properties.get(ID_KEY));
            }
            return Collections.unmodifiableMap(properties);
        }
        return ImmutableMap.builder().putAll(properties).put((Object)ID_KEY, (Object)stringId.toString()).build();
    }

    public static Map<String, String> newPropertiesWithoutId(Map<String, String> properties) {
        if (properties == null) {
            return null;
        }
        if (!properties.containsKey(ID_KEY)) {
            return Collections.unmodifiableMap(properties);
        }
        HashMap copy = Maps.newHashMap(properties);
        copy.remove(ID_KEY);
        return ImmutableMap.builder().putAll((Map)copy).build();
    }

    public static StringIdentifier fromProperties(Map<String, String> properties) {
        if (properties == null) {
            return null;
        }
        String idString = properties.get(ID_KEY);
        if (StringUtils.isBlank((CharSequence)idString)) {
            return null;
        }
        return StringIdentifier.fromString(idString);
    }

    public static String addToComment(StringIdentifier stringId, String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return String.format(STRING_COMMENT_FORMAT, "", STRING_COMMENT, stringId.toString());
        }
        return String.format(STRING_COMMENT_FORMAT, comment + " ", STRING_COMMENT, stringId.toString());
    }

    public static StringIdentifier fromComment(String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return null;
        }
        int index = comment.lastIndexOf(40);
        if (index == -1) {
            return null;
        }
        String idString = comment.substring(index + STRING_COMMENT.length() + 1, comment.length() - 1);
        return StringIdentifier.fromString(idString);
    }

    public static String removeIdFromComment(String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return comment;
        }
        StringIdentifier identifier = StringIdentifier.fromComment(comment);
        if (identifier != null) {
            String format = String.format(STRING_COMMENT_FORMAT, " ", STRING_COMMENT, identifier);
            int indexOf = comment.indexOf(format);
            if (indexOf == -1) {
                format = String.format(STRING_COMMENT_FORMAT, "", STRING_COMMENT, identifier);
                indexOf = comment.indexOf(format);
            }
            if (indexOf != -1) {
                return comment.substring(0, indexOf);
            }
        }
        return comment;
    }
}

