/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Arrays;
import java.util.Map;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedFileset;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class FilesetOperationDispatcher
extends OperationDispatcher
implements FilesetDispatcher {
    public FilesetOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])namespace.levels()), LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithFilesetOps(f -> f.listFilesets(namespace)), NoSuchSchemaException.class));
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Fileset fileset = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(catalogIdent, c -> c.doWithFilesetOps(f -> f.loadFileset(ident)), NoSuchFilesetException.class));
        return EntityCombinedFileset.of(fileset).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::filesetPropertiesMetadata, fileset.properties()));
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.filesetPropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class);
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        Map<String, String> updatedProperties = StringIdentifier.newPropertiesWithId(stringId, properties);
        Fileset createdFileset = TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithFilesetOps(f -> f.createMultipleLocationFileset(ident, comment, type, storageLocations, updatedProperties)), NoSuchSchemaException.class, FilesetAlreadyExistsException.class));
        return EntityCombinedFileset.of(createdFileset).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::filesetPropertiesMetadata, createdFileset.properties()));
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        this.validateAlterProperties(ident, HasPropertyMetadata::filesetPropertiesMetadata, changes);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        boolean containsRenameFileset = Arrays.stream(changes).anyMatch(c -> c instanceof FilesetChange.RenameFileset);
        NameIdentifier nameIdentifierForLock = containsRenameFileset ? NameIdentifier.of((String[])ident.namespace().levels()) : ident;
        Fileset alteredFileset = TreeLockUtils.doWithTreeLock(nameIdentifierForLock, LockType.WRITE, () -> this.doWithCatalog(catalogIdent, c -> c.doWithFilesetOps(f -> f.alterFileset(ident, changes)), NoSuchFilesetException.class, IllegalArgumentException.class));
        return EntityCombinedFileset.of(alteredFileset).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::filesetPropertiesMetadata, alteredFileset.properties()));
    }

    public boolean dropFileset(NameIdentifier ident) {
        return TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithFilesetOps(f -> f.dropFileset(ident)), NonEmptyEntityException.class));
    }

    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException {
        return TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithFilesetOps(f -> f.getFileLocation(ident, subPath, locationName)), NonEmptyEntityException.class));
    }
}

