/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v1;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.Constants;

public class HeadMapSerializer {
    private static final HeadMapSerializer INSTANCE = new HeadMapSerializer();

    private HeadMapSerializer() {
    }

    public static HeadMapSerializer getInstance() {
        return INSTANCE;
    }

    public int encode(Map<String, String> map, ByteBuf out) {
        if (map == null || map.isEmpty() || out == null) {
            return 0;
        }
        int start = out.writerIndex();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null) continue;
            this.writeString(out, key);
            this.writeString(out, value);
        }
        return out.writerIndex() - start;
    }

    public Map<String, String> decode(ByteBuf in, int length) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (in == null || in.readableBytes() == 0 || length == 0) {
            return map;
        }
        int tick = in.readerIndex();
        while (in.readerIndex() - tick < length) {
            String key = this.readString(in);
            String value = this.readString(in);
            map.put(key, value);
        }
        return map;
    }

    protected void writeString(ByteBuf out, String str) {
        if (str == null) {
            out.writeShort(-1);
        } else if (str.isEmpty()) {
            out.writeShort(0);
        } else {
            byte[] bs = str.getBytes(Constants.DEFAULT_CHARSET);
            out.writeShort(bs.length);
            out.writeBytes(bs);
        }
    }

    protected String readString(ByteBuf in) {
        short length = in.readShort();
        if (length < 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] value = new byte[length];
        in.readBytes(value);
        return new String(value, Constants.DEFAULT_CHARSET);
    }
}

