/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.openssl.OpenSSLStatus;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(OpenSSLLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(OpenSSLLifecycleListener.class);
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        if (OpenSSLStatus.isInstanceCreated()) {
            Object object = lock;
            synchronized (object) {
                if (!JreCompat.isJre22Available()) {
                    OpenSSLStatus.setInitialized(true);
                } else {
                    try {
                        Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                        openSSLLibraryClass.getMethod("init", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Throwable t) {
                        Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                        ExceptionUtils.handleThrowable(throwable);
                        log.error(sm.getString("openssllistener.sslInit"), throwable);
                    }
                }
            }
        }
        return OpenSSLStatus.isAvailable();
    }

    public OpenSSLLifecycleListener() {
        OpenSSLStatus.setInstanceCreated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        Throwable throwable;
        Class<?> openSSLLibraryClass;
        Object object;
        boolean initError = false;
        if ("before_init".equals(event.getType())) {
            if (!(event.getLifecycle() instanceof Server)) {
                log.warn(sm.getString("listener.notServer", event.getLifecycle().getClass().getSimpleName()));
            }
            object = lock;
            synchronized (object) {
                if (!JreCompat.isJre22Available()) {
                    log.info(sm.getString("openssllistener.java22"));
                    OpenSSLStatus.setInitialized(true);
                    return;
                }
                try {
                    openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                    openSSLLibraryClass.getMethod("init", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                    ExceptionUtils.handleThrowable(throwable);
                    log.error(sm.getString("openssllistener.sslInit"), throwable);
                    initError = true;
                }
                if (null != this.getFIPSMode() && !"off".equalsIgnoreCase(this.getFIPSMode()) && !this.isFIPSModeActive()) {
                    String errorMessage = sm.getString("openssllistener.initializeFIPSFailed");
                    Error e = new Error(errorMessage);
                    log.fatal(errorMessage, e);
                    initError = true;
                }
            }
        }
        if (initError || "after_destroy".equals(event.getType())) {
            object = lock;
            synchronized (object) {
                if (!JreCompat.isJre22Available()) {
                    return;
                }
                try {
                    openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                    openSSLLibraryClass.getMethod("destroy", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                    ExceptionUtils.handleThrowable(throwable);
                    log.info(sm.getString("openssllistener.destroy"));
                }
            }
        }
    }

    public String getSSLEngine() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)openSSLLibraryClass.getMethod("getSSLEngine", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
        return null;
    }

    public void setSSLEngine(String SSLEngine2) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                openSSLLibraryClass.getMethod("setSSLEngine", String.class).invoke(null, SSLEngine2);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
    }

    public String getSSLRandomSeed() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)openSSLLibraryClass.getMethod("getSSLRandomSeed", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
        return null;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                openSSLLibraryClass.getMethod("setSSLRandomSeed", String.class).invoke(null, SSLRandomSeed);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
    }

    public String getFIPSMode() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)openSSLLibraryClass.getMethod("getFIPSMode", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
        return null;
    }

    public void setFIPSMode(String FIPSMode) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                openSSLLibraryClass.getMethod("setFIPSMode", String.class).invoke(null, FIPSMode);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
    }

    public boolean isFIPSModeActive() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> openSSLLibraryClass = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (Boolean)openSSLLibraryClass.getMethod("isFIPSModeActive", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(throwable);
            }
        }
        return false;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        if (useOpenSSL != OpenSSLStatus.getUseOpenSSL()) {
            OpenSSLStatus.setUseOpenSSL(useOpenSSL);
        }
    }

    public static boolean getUseOpenSSL() {
        return OpenSSLStatus.getUseOpenSSL();
    }
}

