/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.request;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.request.AsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.request.DefaultHttpClientRequest;
import com.alibaba.nacos.common.http.client.response.DefaultClientHttpResponse;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.ExceptionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncHttpClientRequest
implements AsyncHttpClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClientRequest.class);
    private final CloseableHttpAsyncClient asyncClient;
    private final DefaultConnectingIOReactor ioreactor;
    private final RequestConfig defaultConfig;

    public DefaultAsyncHttpClientRequest(CloseableHttpAsyncClient asyncClient, DefaultConnectingIOReactor ioreactor, RequestConfig defaultConfig) {
        this.asyncClient = asyncClient;
        this.ioreactor = ioreactor;
        this.defaultConfig = defaultConfig;
        if (!this.asyncClient.isRunning()) {
            this.asyncClient.start();
        }
    }

    @Override
    public <T> void execute(URI uri, String httpMethod, RequestHttpEntity requestHttpEntity, final ResponseHandler<T> responseHandler, final Callback<T> callback) throws Exception {
        HttpRequestBase httpRequestBase = DefaultHttpClientRequest.build(uri, httpMethod, requestHttpEntity, this.defaultConfig);
        try {
            this.asyncClient.execute((HttpUriRequest)httpRequestBase, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse result) {
                    DefaultClientHttpResponse response = new DefaultClientHttpResponse(result);
                    try {
                        HttpRestResult httpRestResult = responseHandler.handle(response);
                        callback.onReceive(httpRestResult);
                    }
                    catch (Exception e) {
                        callback.onError(e);
                    }
                }

                public void failed(Exception ex) {
                    callback.onError(ex);
                }

                public void cancelled() {
                    callback.onCancel();
                }
            });
        }
        catch (IllegalStateException e) {
            List events = this.ioreactor.getAuditLog();
            if (events != null) {
                for (ExceptionEvent event : events) {
                    if (event == null) continue;
                    LOGGER.error("[DefaultAsyncHttpClientRequest] IllegalStateException! I/O Reactor error time: {}", (Object)event.getTimestamp(), (Object)event.getCause());
                }
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.asyncClient.close();
    }
}

