/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.env;

import org.apache.seata.common.util.NumberUtils;
import org.apache.seata.common.util.StringUtils;

public class ContainerHelper {
    private static final String C_GROUP_PATH = "/proc/1/cgroup";
    private static final String DOCKER_PATH = "/docker";
    private static final String KUBEPODS_PATH = "/kubepods";
    private static final String ENV_SYSTEM_KEY = "SEATA_ENV";
    private static final String ENV_SEATA_IP_KEY = "SEATA_IP";
    private static final String ENV_SERVER_NODE_KEY = "SERVER_NODE";
    private static final String ENV_STORE_MODE_KEY = "STORE_MODE";
    private static final String ENV_LOCK_STORE_MODE_KEY = "LOCK_STORE_MODE";
    private static final String ENV_SESSION_STORE_MODE_KEY = "SESSION_STORE_MODE";

    public static String getEnv() {
        return StringUtils.trimToNull((String)System.getenv(ENV_SYSTEM_KEY));
    }

    public static String getHost() {
        return StringUtils.trimToNull((String)System.getenv(ENV_SEATA_IP_KEY));
    }

    public static int getPort() {
        return NumberUtils.toInt((String)System.getenv("SEATA_PORT"), (int)0);
    }

    public static Long getServerNode() {
        return NumberUtils.toLong((String)System.getenv(ENV_SERVER_NODE_KEY));
    }

    public static String getStoreMode() {
        return StringUtils.trimToNull((String)System.getenv(ENV_STORE_MODE_KEY));
    }

    public static String getSessionStoreMode() {
        return StringUtils.trimToNull((String)System.getenv(ENV_SESSION_STORE_MODE_KEY));
    }

    public static String getLockStoreMode() {
        return StringUtils.trimToNull((String)System.getenv(ENV_LOCK_STORE_MODE_KEY));
    }
}

