/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.concurrent;

import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.alipay.sofa.jraft.util.concurrent.DefaultFixedThreadsExecutorGroup;
import com.alipay.sofa.jraft.util.concurrent.DefaultSingleThreadExecutor;
import com.alipay.sofa.jraft.util.concurrent.ExecutorChooserFactory;
import com.alipay.sofa.jraft.util.concurrent.FixedThreadsExecutorGroup;
import com.alipay.sofa.jraft.util.concurrent.FixedThreadsExecutorGroupFactory;
import com.alipay.sofa.jraft.util.concurrent.MpscSingleThreadExecutor;
import com.alipay.sofa.jraft.util.concurrent.SingleThreadExecutor;
import java.util.concurrent.ExecutorService;

public final class DefaultFixedThreadsExecutorGroupFactory
implements FixedThreadsExecutorGroupFactory {
    public static final DefaultFixedThreadsExecutorGroupFactory INSTANCE = new DefaultFixedThreadsExecutorGroupFactory();

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(int nThreads, String poolName, int maxPendingTasksPerThread) {
        return this.newExecutorGroup(nThreads, poolName, maxPendingTasksPerThread, false);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(int nThreads, String poolName, int maxPendingTasksPerThread, boolean useMpscQueue) {
        Requires.requireTrue(nThreads > 0, "nThreads must > 0");
        boolean mpsc = useMpscQueue && Utils.USE_MPSC_SINGLE_THREAD_EXECUTOR;
        SingleThreadExecutor[] children = new SingleThreadExecutor[nThreads];
        NamedThreadFactory threadFactory = mpsc ? new NamedThreadFactory(poolName, true) : null;
        for (int i = 0; i < nThreads; ++i) {
            children[i] = mpsc ? new MpscSingleThreadExecutor(maxPendingTasksPerThread, threadFactory) : new DefaultSingleThreadExecutor(poolName, maxPendingTasksPerThread);
        }
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(SingleThreadExecutor[] children) {
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(SingleThreadExecutor[] children, ExecutorChooserFactory.ExecutorChooser chooser) {
        return new DefaultFixedThreadsExecutorGroup(children, chooser);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(ExecutorService[] children) {
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(ExecutorService[] children, ExecutorChooserFactory.ExecutorChooser chooser) {
        return new DefaultFixedThreadsExecutorGroup(children, chooser);
    }

    private DefaultFixedThreadsExecutorGroupFactory() {
    }
}

