/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.StaticMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.loader.InterceptorInstanceLoader;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;

public class StaticMethodsInterV2WithOverrideArgs {
    private static final ILog LOGGER = LogManager.getLogger(StaticMethodsInterV2WithOverrideArgs.class);
    private String staticMethodsAroundInterceptorClassName;

    public StaticMethodsInterV2WithOverrideArgs(String staticMethodsAroundInterceptorClassName) {
        this.staticMethodsAroundInterceptorClassName = staticMethodsAroundInterceptorClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @Morph OverrideCallable zuper) throws Throwable {
        StaticMethodsAroundInterceptorV2 interceptor = (StaticMethodsAroundInterceptorV2)InterceptorInstanceLoader.load(this.staticMethodsAroundInterceptorClassName, clazz.getClassLoader());
        MethodInvocationContext context = new MethodInvocationContext();
        try {
            interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), context);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] before static method[{}] intercept failure", clazz, method.getName());
        }
        Object ret = null;
        try {
            ret = !context.isContinue() ? context._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                try {
                    interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t, context);
                    throw t;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] handle static method[{}] exception failure", clazz, method.getName(), t2.getMessage());
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret, context);
                    throw throwable;
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            return interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret, context);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t.getMessage());
            return ret;
        }
    }
}

